/*
 * Decompiled with CFR 0.152.
 */
package javax.media.format;

import javax.media.Format;
import net.sf.fmj.codegen.FormatTraceUtils;
import net.sf.fmj.utility.FormatUtils;

public class AudioFormat
extends Format {
    public static final int BIG_ENDIAN = 1;
    public static final int LITTLE_ENDIAN = 0;
    public static final int SIGNED = 1;
    public static final int UNSIGNED = 0;
    protected double sampleRate = -1.0;
    protected int sampleSizeInBits = -1;
    protected int channels = -1;
    protected int endian = -1;
    protected int signed = -1;
    protected double frameRate = -1.0;
    protected int frameSizeInBits = -1;
    public static final String LINEAR = "LINEAR";
    public static final String ULAW = "ULAW";
    public static final String ULAW_RTP = "ULAW/rtp";
    public static final String ALAW = "alaw";
    public static final String IMA4 = "ima4";
    public static final String IMA4_MS = "ima4/ms";
    public static final String MSADPCM = "msadpcm";
    public static final String DVI = "dvi";
    public static final String DVI_RTP = "dvi/rtp";
    public static final String G723 = "g723";
    public static final String G723_RTP = "g723/rtp";
    public static final String G728 = "g728";
    public static final String G728_RTP = "g728/rtp";
    public static final String G729 = "g729";
    public static final String G729_RTP = "g729/rtp";
    public static final String G729A = "g729a";
    public static final String G729A_RTP = "g729a/rtp";
    public static final String GSM = "gsm";
    public static final String GSM_MS = "gsm/ms";
    public static final String GSM_RTP = "gsm/rtp";
    public static final String MAC3 = "MAC3";
    public static final String MAC6 = "MAC6";
    public static final String TRUESPEECH = "truespeech";
    public static final String MSNAUDIO = "msnaudio";
    public static final String MPEGLAYER3 = "mpeglayer3";
    public static final String VOXWAREAC8 = "voxwareac8";
    public static final String VOXWAREAC10 = "voxwareac10";
    public static final String VOXWAREAC16 = "voxwareac16";
    public static final String VOXWAREAC20 = "voxwareac20";
    public static final String VOXWAREMETAVOICE = "voxwaremetavoice";
    public static final String VOXWAREMETASOUND = "voxwaremetasound";
    public static final String VOXWARERT29H = "voxwarert29h";
    public static final String VOXWAREVR12 = "voxwarevr12";
    public static final String VOXWAREVR18 = "voxwarevr18";
    public static final String VOXWARETQ40 = "voxwaretq40";
    public static final String VOXWARETQ60 = "voxwaretq60";
    public static final String MSRT24 = "msrt24";
    public static final String MPEG = "mpegaudio";
    public static final String MPEG_RTP = "mpegaudio/rtp";
    public static final String DOLBYAC3 = "dolbyac3";
    double multiplier = -1.0;
    int margin = 0;
    boolean init = false;

    public AudioFormat(String encoding) {
        super(encoding);
        this.dataType = byteArray;
    }

    public AudioFormat(String encoding, double sampleRate, int sampleSizeInBits, int channels) {
        super(encoding);
        this.dataType = byteArray;
        this.sampleRate = sampleRate;
        this.sampleSizeInBits = sampleSizeInBits;
        this.channels = channels;
    }

    public AudioFormat(String encoding, double sampleRate, int sampleSizeInBits, int channels, int endian, int signed) {
        super(encoding);
        this.dataType = byteArray;
        this.sampleRate = sampleRate;
        this.sampleSizeInBits = sampleSizeInBits;
        this.channels = channels;
        this.endian = endian;
        this.signed = signed;
    }

    public AudioFormat(String encoding, double sampleRate, int sampleSizeInBits, int channels, int endian, int signed, int frameSizeInBits, double frameRate, Class dataType) {
        super(encoding, dataType);
        this.sampleRate = sampleRate;
        this.sampleSizeInBits = sampleSizeInBits;
        this.channels = channels;
        this.endian = endian;
        this.signed = signed;
        this.frameSizeInBits = frameSizeInBits;
        this.frameRate = frameRate;
    }

    public double getSampleRate() {
        return this.sampleRate;
    }

    public int getSampleSizeInBits() {
        return this.sampleSizeInBits;
    }

    public int getChannels() {
        return this.channels;
    }

    public int getEndian() {
        return this.endian;
    }

    public int getSigned() {
        return this.signed;
    }

    public int getFrameSizeInBits() {
        return this.frameSizeInBits;
    }

    public double getFrameRate() {
        return this.frameRate;
    }

    public long computeDuration(long length) {
        int frameSizeInBits;
        double frameRate;
        if (FormatUtils.specified(this.frameRate) && FormatUtils.specified(this.frameSizeInBits)) {
            frameRate = this.frameRate;
            frameSizeInBits = this.frameSizeInBits;
        } else if (FormatUtils.specified(this.sampleRate) && FormatUtils.specified(this.sampleSizeInBits) && FormatUtils.specified(this.channels)) {
            frameRate = this.sampleRate;
            frameSizeInBits = this.sampleSizeInBits * this.channels;
        } else {
            return -1L;
        }
        return 1000L * (long)((double)(length * 8L) * 1000000.0 / (frameRate * (double)frameSizeInBits));
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(this.encoding);
        b.append(", ");
        if (FormatUtils.specified(this.sampleRate)) {
            b.append(this.sampleRate + " Hz");
        } else {
            b.append("Unknown Sample Rate");
        }
        if (FormatUtils.specified(this.sampleSizeInBits)) {
            b.append(", ");
            b.append("" + this.sampleSizeInBits + "-bit");
        }
        if (FormatUtils.specified(this.channels)) {
            b.append(", ");
            if (this.channels == 1) {
                b.append("Mono");
            } else if (this.channels == 2) {
                b.append("Stereo");
            } else {
                b.append("" + this.channels + "-channel");
            }
        }
        if (FormatUtils.specified(this.endian) && FormatUtils.specified(this.sampleSizeInBits) && this.sampleSizeInBits > 8) {
            if (this.endian == 1) {
                b.append(", ");
                b.append("BigEndian");
            } else if (this.endian == 0) {
                b.append(", ");
                b.append("LittleEndian");
            }
        }
        if (FormatUtils.specified(this.signed)) {
            b.append(", ");
            if (this.signed != 1) {
                b.append("Unsigned");
            } else {
                b.append("Signed");
            }
        }
        if (FormatUtils.specified(this.frameRate)) {
            b.append(", ");
            b.append("" + this.frameRate + " frame rate");
        }
        if (FormatUtils.specified(this.frameSizeInBits)) {
            b.append(", FrameSize=" + this.frameSizeInBits + " bits");
        }
        return b.toString();
    }

    public boolean equals(Object format) {
        if (!super.equals(format)) {
            return false;
        }
        if (!(format instanceof AudioFormat)) {
            return false;
        }
        AudioFormat oCast = (AudioFormat)format;
        return this.sampleRate == oCast.sampleRate && this.sampleSizeInBits == oCast.sampleSizeInBits && this.channels == oCast.channels && this.endian == oCast.endian && this.signed == oCast.signed && this.frameSizeInBits == oCast.frameSizeInBits && this.frameRate == oCast.frameRate;
    }

    public boolean matches(Format format) {
        boolean result;
        if (!super.matches(format)) {
            if (this.getClass() == FormatUtils.audioFormatClass) {
                FormatTraceUtils.traceMatches(this, format, false);
            }
            return false;
        }
        if (!(format instanceof AudioFormat)) {
            boolean result2 = true;
            if (this.getClass() == FormatUtils.audioFormatClass) {
                FormatTraceUtils.traceMatches(this, format, true);
            }
            return true;
        }
        AudioFormat oCast = (AudioFormat)format;
        boolean bl = result = FormatUtils.matches(this.sampleRate, oCast.sampleRate) && FormatUtils.matches(this.sampleSizeInBits, oCast.sampleSizeInBits) && FormatUtils.matches(this.channels, oCast.channels) && FormatUtils.matches(this.endian, oCast.endian) && FormatUtils.matches(this.signed, oCast.signed) && FormatUtils.matches(this.frameSizeInBits, oCast.frameSizeInBits) && FormatUtils.matches(this.frameRate, oCast.frameRate);
        if (this.getClass() == FormatUtils.audioFormatClass) {
            FormatTraceUtils.traceMatches(this, format, result);
        }
        return result;
    }

    public Format intersects(Format other) {
        Format result = super.intersects(other);
        if (other instanceof AudioFormat) {
            AudioFormat resultCast = (AudioFormat)result;
            AudioFormat oCast = (AudioFormat)other;
            if (this.getClass().isAssignableFrom(other.getClass())) {
                if (FormatUtils.specified(this.sampleRate)) {
                    resultCast.sampleRate = this.sampleRate;
                }
                if (FormatUtils.specified(this.sampleSizeInBits)) {
                    resultCast.sampleSizeInBits = this.sampleSizeInBits;
                }
                if (FormatUtils.specified(this.channels)) {
                    resultCast.channels = this.channels;
                }
                if (FormatUtils.specified(this.endian)) {
                    resultCast.endian = this.endian;
                }
                if (FormatUtils.specified(this.signed)) {
                    resultCast.signed = this.signed;
                }
                if (FormatUtils.specified(this.frameSizeInBits)) {
                    resultCast.frameSizeInBits = this.frameSizeInBits;
                }
                if (FormatUtils.specified(this.frameRate)) {
                    resultCast.frameRate = this.frameRate;
                }
            } else if (other.getClass().isAssignableFrom(this.getClass())) {
                if (!FormatUtils.specified(resultCast.sampleRate)) {
                    resultCast.sampleRate = oCast.sampleRate;
                }
                if (!FormatUtils.specified(resultCast.sampleSizeInBits)) {
                    resultCast.sampleSizeInBits = oCast.sampleSizeInBits;
                }
                if (!FormatUtils.specified(resultCast.channels)) {
                    resultCast.channels = oCast.channels;
                }
                if (!FormatUtils.specified(resultCast.endian)) {
                    resultCast.endian = oCast.endian;
                }
                if (!FormatUtils.specified(resultCast.signed)) {
                    resultCast.signed = oCast.signed;
                }
                if (!FormatUtils.specified(resultCast.frameSizeInBits)) {
                    resultCast.frameSizeInBits = oCast.frameSizeInBits;
                }
                if (!FormatUtils.specified(resultCast.frameRate)) {
                    resultCast.frameRate = oCast.frameRate;
                }
            }
        }
        if (this.getClass() == FormatUtils.audioFormatClass) {
            FormatTraceUtils.traceIntersects(this, other, result);
        }
        return result;
    }

    public Object clone() {
        return new AudioFormat(this.encoding, this.sampleRate, this.sampleSizeInBits, this.channels, this.endian, this.signed, this.frameSizeInBits, this.frameRate, this.dataType);
    }

    protected void copy(Format f) {
        super.copy(f);
        AudioFormat oCast = (AudioFormat)f;
        this.sampleRate = oCast.sampleRate;
        this.sampleSizeInBits = oCast.sampleSizeInBits;
        this.channels = oCast.channels;
        this.endian = oCast.endian;
        this.signed = oCast.signed;
        this.frameSizeInBits = oCast.frameSizeInBits;
        this.frameRate = oCast.frameRate;
    }
}

