/*
 * Decompiled with CFR 0.152.
 */
package javazoom.spi.vorbis.sampled.file;

import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import com.jcraft.jogg.StreamState;
import com.jcraft.jogg.SyncState;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.Info;
import com.jcraft.jorbis.JOrbisException;
import com.jcraft.jorbis.VorbisFile;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.constant.Constable;
import java.net.URL;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import javazoom.spi.vorbis.sampled.file.VorbisAudioFileFormat;
import javazoom.spi.vorbis.sampled.file.VorbisAudioFormat;
import javazoom.spi.vorbis.sampled.file.VorbisEncoding;
import javazoom.spi.vorbis.sampled.file.VorbisFileFormatType;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.file.TAudioFileReader;

public class VorbisAudioFileReader
extends TAudioFileReader {
    private SyncState oggSyncState_ = null;
    private StreamState oggStreamState_ = null;
    private Page oggPage_ = null;
    private Packet oggPacket_ = null;
    private Info vorbisInfo = null;
    private Comment vorbisComment = null;
    private DspState vorbisDspState = null;
    private Block vorbisBlock = null;
    private int bufferMultiple_ = 4;
    private int bufferSize_ = this.bufferMultiple_ * 256 * 2;
    private byte[] buffer = null;
    private int bytes = 0;
    private int index = 0;
    private InputStream oggBitStream_ = null;
    private static final int INITAL_READ_LENGTH = 64000;
    private static final int MARK_LIMIT = 64001;

    public VorbisAudioFileReader() {
        super(64001, true);
    }

    public AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("getAudioFileFormat(File file)");
        }
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file));
            inputStream.mark(64001);
            AudioFileFormat audioFileFormat = this.getAudioFileFormat(inputStream);
            inputStream.reset();
            VorbisFile vorbisFile = new VorbisFile(file.getAbsolutePath());
            AudioFileFormat audioFileFormat2 = this.getAudioFileFormat(inputStream, (int)file.length(), Math.round(vorbisFile.time_total(-1) * 1000.0f));
            return audioFileFormat2;
        }
        catch (JOrbisException jOrbisException) {
            throw new IOException(jOrbisException.getMessage());
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioFileFormat getAudioFileFormat(URL uRL) throws UnsupportedAudioFileException, IOException {
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("getAudioFileFormat(URL url)");
        }
        InputStream inputStream = uRL.openStream();
        try {
            AudioFileFormat audioFileFormat = this.getAudioFileFormat(inputStream);
            return audioFileFormat;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioFileFormat getAudioFileFormat(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("getAudioFileFormat(InputStream inputStream)");
        }
        try {
            if (!inputStream.markSupported()) {
                inputStream = new BufferedInputStream(inputStream);
            }
            inputStream.mark(64001);
            AudioFileFormat audioFileFormat = this.getAudioFileFormat(inputStream, -1, -1);
            return audioFileFormat;
        }
        finally {
            inputStream.reset();
        }
    }

    public AudioFileFormat getAudioFileFormat(InputStream inputStream, long l) throws UnsupportedAudioFileException, IOException {
        return this.getAudioFileFormat(inputStream, (int)l, -1);
    }

    protected AudioFileFormat getAudioFileFormat(InputStream inputStream, int n, int n2) throws UnsupportedAudioFileException, IOException {
        Object object;
        HashMap<String, Number> hashMap = new HashMap<String, Number>();
        HashMap<String, Constable> hashMap2 = new HashMap<String, Constable>();
        if (n2 == -1) {
            n2 = 0;
        }
        if (n2 <= 0) {
            n2 = 0;
        } else {
            hashMap.put("duration", new Long(n2 * 1000));
        }
        this.oggBitStream_ = inputStream;
        this.init_jorbis();
        this.index = 0;
        try {
            this.readHeaders(hashMap, hashMap2);
        }
        catch (IOException iOException) {
            if (TDebug.TraceAudioFileReader) {
                TDebug.out(iOException.getMessage());
            }
            throw new UnsupportedAudioFileException(iOException.getMessage());
        }
        String string = this.vorbisInfo.toString();
        if (TDebug.TraceAudioFileReader) {
            TDebug.out(string);
        }
        int n3 = string.lastIndexOf("bitrate:");
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        if (n3 != -1) {
            object = new StringTokenizer(string = string.substring(n3 + 8, string.length()), ",");
            if (((StringTokenizer)object).hasMoreTokens()) {
                n4 = Integer.parseInt(((StringTokenizer)object).nextToken());
            }
            if (((StringTokenizer)object).hasMoreTokens()) {
                n5 = Integer.parseInt(((StringTokenizer)object).nextToken());
            }
            if (((StringTokenizer)object).hasMoreTokens()) {
                n6 = Integer.parseInt(((StringTokenizer)object).nextToken());
            }
        }
        if (n5 > 0) {
            hashMap2.put("bitrate", new Integer(n5));
        }
        hashMap2.put("vbr", new Boolean(true));
        if (n4 > 0) {
            hashMap.put("ogg.bitrate.min.bps", new Integer(n4));
        }
        if (n6 > 0) {
            hashMap.put("ogg.bitrate.max.bps", new Integer(n6));
        }
        if (n5 > 0) {
            hashMap.put("ogg.bitrate.nominal.bps", new Integer(n5));
        }
        if (this.vorbisInfo.channels > 0) {
            hashMap.put("ogg.channels", new Integer(this.vorbisInfo.channels));
        }
        if (this.vorbisInfo.rate > 0) {
            hashMap.put("ogg.frequency.hz", new Integer(this.vorbisInfo.rate));
        }
        if (n > 0) {
            hashMap.put("ogg.length.bytes", new Integer(n));
        }
        hashMap.put("ogg.version", new Integer(this.vorbisInfo.version));
        object = VorbisEncoding.VORBISENC;
        VorbisAudioFormat vorbisAudioFormat = new VorbisAudioFormat((AudioFormat.Encoding)object, (float)this.vorbisInfo.rate, -1, this.vorbisInfo.channels, -1, -1.0f, true, hashMap2);
        return new VorbisAudioFileFormat(VorbisFileFormatType.OGG, vorbisAudioFormat, -1, n, hashMap);
    }

    public AudioInputStream getAudioInputStream(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("getAudioInputStream(InputStream inputStream)");
        }
        return this.getAudioInputStream(inputStream, -1, -1);
    }

    public AudioInputStream getAudioInputStream(InputStream inputStream, int n, int n2) throws UnsupportedAudioFileException, IOException {
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("getAudioInputStream(InputStream inputStreamint medialength, int totalms)");
        }
        try {
            if (!inputStream.markSupported()) {
                inputStream = new BufferedInputStream(inputStream);
            }
            inputStream.mark(64001);
            AudioFileFormat audioFileFormat = this.getAudioFileFormat(inputStream, n, n2);
            inputStream.reset();
            return new AudioInputStream(inputStream, audioFileFormat.getFormat(), audioFileFormat.getFrameLength());
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            inputStream.reset();
            throw unsupportedAudioFileException;
        }
        catch (IOException iOException) {
            inputStream.reset();
            throw iOException;
        }
    }

    public AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("getAudioInputStream(File file)");
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            return this.getAudioInputStream(fileInputStream);
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
            throw unsupportedAudioFileException;
        }
        catch (IOException iOException) {
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
            throw iOException;
        }
    }

    public AudioInputStream getAudioInputStream(URL uRL) throws UnsupportedAudioFileException, IOException {
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("getAudioInputStream(URL url)");
        }
        InputStream inputStream = uRL.openStream();
        try {
            return this.getAudioInputStream(inputStream);
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            if (inputStream != null) {
                inputStream.close();
            }
            throw unsupportedAudioFileException;
        }
        catch (IOException iOException) {
            if (inputStream != null) {
                inputStream.close();
            }
            throw iOException;
        }
    }

    private void readHeaders(HashMap hashMap, HashMap hashMap2) throws IOException {
        if (TDebug.TraceAudioConverter) {
            TDebug.out("readHeaders(");
        }
        this.index = this.oggSyncState_.buffer(this.bufferSize_);
        this.buffer = this.oggSyncState_.data;
        this.bytes = this.readFromStream(this.buffer, this.index, this.bufferSize_);
        if (this.bytes == -1) {
            if (TDebug.TraceAudioConverter) {
                TDebug.out("Cannot get any data from selected Ogg bitstream.");
            }
            throw new IOException("Cannot get any data from selected Ogg bitstream.");
        }
        this.oggSyncState_.wrote(this.bytes);
        if (this.oggSyncState_.pageout(this.oggPage_) != 1) {
            if (this.bytes < this.bufferSize_) {
                throw new IOException("EOF");
            }
            if (TDebug.TraceAudioConverter) {
                TDebug.out("Input does not appear to be an Ogg bitstream.");
            }
            throw new IOException("Input does not appear to be an Ogg bitstream.");
        }
        this.oggStreamState_.init(this.oggPage_.serialno());
        this.vorbisInfo.init();
        this.vorbisComment.init();
        hashMap.put("ogg.serial", new Integer(this.oggPage_.serialno()));
        if (this.oggStreamState_.pagein(this.oggPage_) < 0) {
            if (TDebug.TraceAudioConverter) {
                TDebug.out("Error reading first page of Ogg bitstream data.");
            }
            throw new IOException("Error reading first page of Ogg bitstream data.");
        }
        if (this.oggStreamState_.packetout(this.oggPacket_) != 1) {
            if (TDebug.TraceAudioConverter) {
                TDebug.out("Error reading initial header packet.");
            }
            throw new IOException("Error reading initial header packet.");
        }
        if (this.vorbisInfo.synthesis_headerin(this.vorbisComment, this.oggPacket_) < 0) {
            if (TDebug.TraceAudioConverter) {
                TDebug.out("This Ogg bitstream does not contain Vorbis audio data.");
            }
            throw new IOException("This Ogg bitstream does not contain Vorbis audio data.");
        }
        int n = 0;
        while (n < 2) {
            int n2;
            while (n < 2 && (n2 = this.oggSyncState_.pageout(this.oggPage_)) != 0) {
                if (n2 != 1) continue;
                this.oggStreamState_.pagein(this.oggPage_);
                while (n < 2 && (n2 = this.oggStreamState_.packetout(this.oggPacket_)) != 0) {
                    if (n2 == -1) {
                        if (TDebug.TraceAudioConverter) {
                            TDebug.out("Corrupt secondary header.  Exiting.");
                        }
                        throw new IOException("Corrupt secondary header.  Exiting.");
                    }
                    this.vorbisInfo.synthesis_headerin(this.vorbisComment, this.oggPacket_);
                    ++n;
                }
            }
            this.index = this.oggSyncState_.buffer(this.bufferSize_);
            this.buffer = this.oggSyncState_.data;
            this.bytes = this.readFromStream(this.buffer, this.index, this.bufferSize_);
            if (this.bytes == -1) break;
            if (this.bytes == 0 && n < 2) {
                if (TDebug.TraceAudioConverter) {
                    TDebug.out("End of file before finding all Vorbis headers!");
                }
                throw new IOException("End of file before finding all Vorbis  headers!");
            }
            this.oggSyncState_.wrote(this.bytes);
        }
        byte[][] byArray = this.vorbisComment.user_comments;
        String string = "";
        int n3 = 0;
        for (int i = 0; i < byArray.length && byArray[i] != null; ++i) {
            string = new String(byArray[i], 0, byArray[i].length - 1, "UTF-8").trim();
            if (TDebug.TraceAudioConverter) {
                TDebug.out(string);
            }
            if (string.toLowerCase().startsWith("artist")) {
                hashMap.put("author", string.substring(7));
            } else if (string.toLowerCase().startsWith("title")) {
                hashMap.put("title", string.substring(6));
            } else if (string.toLowerCase().startsWith("album")) {
                hashMap.put("album", string.substring(6));
            } else if (string.toLowerCase().startsWith("date")) {
                hashMap.put("date", string.substring(5));
            } else if (string.toLowerCase().startsWith("copyright")) {
                hashMap.put("copyright", string.substring(10));
            } else if (string.toLowerCase().startsWith("comment")) {
                hashMap.put("comment", string.substring(8));
            } else if (string.toLowerCase().startsWith("genre")) {
                hashMap.put("ogg.comment.genre", string.substring(6));
            } else if (string.toLowerCase().startsWith("tracknumber")) {
                hashMap.put("ogg.comment.track", string.substring(12));
            } else {
                hashMap.put("ogg.comment.ext." + ++n3, string);
            }
            hashMap.put("ogg.comment.encodedby", new String(this.vorbisComment.vendor, 0, this.vorbisComment.vendor.length - 1));
        }
    }

    private int readFromStream(byte[] byArray, int n, int n2) {
        int n3 = 0;
        try {
            n3 = this.oggBitStream_.read(byArray, n, n2);
        }
        catch (Exception exception) {
            if (TDebug.TraceAudioFileReader) {
                TDebug.out("Cannot Read Selected Song");
            }
            n3 = -1;
        }
        return n3;
    }

    private void init_jorbis() {
        this.oggSyncState_ = new SyncState();
        this.oggStreamState_ = new StreamState();
        this.oggPage_ = new Page();
        this.oggPacket_ = new Packet();
        this.vorbisInfo = new Info();
        this.vorbisComment = new Comment();
        this.vorbisDspState = new DspState();
        this.vorbisBlock = new Block(this.vorbisDspState);
        this.buffer = null;
        this.bytes = 0;
        this.oggSyncState_.init();
    }
}

