/*
 * Decompiled with CFR 0.152.
 */
package memetic.crypto;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import memetic.crypto.RTPCrypt;

public class EncryptedRTPSocket
extends MulticastSocket {
    private RTPCrypt crypt = null;
    private boolean isRTP = true;

    public EncryptedRTPSocket(RTPCrypt crypt, int port) throws IOException {
        super(port);
        this.crypt = crypt;
        this.isRTP = port % 2 == 0;
    }

    public EncryptedRTPSocket(RTPCrypt crypt, InetAddress addr, int port, boolean isRTP) throws IOException {
        super(new InetSocketAddress(addr, port));
        this.crypt = crypt;
        this.isRTP = isRTP;
    }

    public EncryptedRTPSocket(RTPCrypt crypt, InetAddress addr, int port) throws IOException {
        super(new InetSocketAddress(addr, port));
        this.crypt = crypt;
        this.isRTP = port % 2 == 0;
    }

    public EncryptedRTPSocket(RTPCrypt crypt, int port, boolean isRTP) throws IOException {
        super(port);
        this.crypt = crypt;
        this.isRTP = isRTP;
    }

    public void send(DatagramPacket p) throws IOException {
        if (this.crypt != null) {
            try {
                if (this.isRTP) {
                    byte[] out = new byte[this.crypt.getEncryptOutputSize(p.getLength())];
                    int length = this.crypt.encryptData(p.getData(), p.getOffset(), p.getLength(), out, 0);
                    p.setData(out, 0, length);
                    super.send(p);
                }
                byte[] out = new byte[this.crypt.getEncryptOutputSize(p.getLength())];
                int length = this.crypt.encryptCtrl(p.getData(), p.getOffset(), p.getLength(), out, 0);
                p.setData(out, 0, length);
                super.send(p);
            }
            catch (InvalidKeyException e) {
                throw new IOException(e.getMessage());
            }
            catch (ShortBufferException e) {
                throw new IOException(e.getMessage());
            }
            catch (IllegalBlockSizeException e) {
                throw new IOException(e.getMessage());
            }
            catch (BadPaddingException e) {
                throw new IOException(e.getMessage());
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new IOException(e.getMessage());
            }
        } else {
            super.send(p);
        }
    }

    public void receive(DatagramPacket p) throws IOException {
        super.receive(p);
        if (this.crypt != null) {
            try {
                if (p.getLength() % this.crypt.getBlockSize() == 0) {
                    if (this.isRTP) {
                        byte[] out = new byte[this.crypt.getDecryptOutputSize(p.getLength())];
                        int length = this.crypt.decryptData(p.getData(), p.getOffset(), p.getLength(), out, 0);
                        if (length > 0) {
                            int maxlen = p.getLength();
                            if (length < p.getLength()) {
                                maxlen = length;
                            }
                            System.arraycopy(out, 0, p.getData(), p.getOffset(), maxlen);
                            p.setLength(maxlen);
                        } else {
                            p.setLength(0);
                        }
                    } else {
                        byte[] out = new byte[this.crypt.getDecryptOutputSize(p.getLength())];
                        int length = this.crypt.decryptCtrl(p.getData(), p.getOffset(), p.getLength(), out, 0);
                        if (length > 0) {
                            int maxlen = p.getLength();
                            if (length < p.getLength()) {
                                maxlen = length;
                            }
                            System.arraycopy(out, 0, p.getData(), p.getOffset(), maxlen);
                            p.setLength(maxlen);
                        } else {
                            p.setLength(0);
                        }
                    }
                }
            }
            catch (InvalidKeyException e) {
                throw new IOException(e.getMessage());
            }
            catch (ShortBufferException e) {
                throw new IOException(e.getMessage());
            }
            catch (IllegalBlockSizeException e) {
                throw new IOException(e.getMessage());
            }
            catch (BadPaddingException e) {
                throw new IOException(e.getMessage());
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new IOException(e.getMessage());
            }
        }
    }

    public void setEncryption(RTPCrypt crypt) {
        this.crypt = crypt;
    }
}

