/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.mf.media.content.unknown;

import com.sun.jna.Native;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Duration;
import javax.media.IncompatibleSourceException;
import javax.media.Time;
import javax.media.protocol.DataSource;
import javax.swing.SwingUtilities;
import net.sf.fmj.concurrent.ExecutorServiceManager;
import net.sf.fmj.ejmf.toolkit.media.AbstractPlayer;
import net.sf.fmj.gui.controlpanelfactory.ControlPanelFactorySingleton;
import net.sf.fmj.media.AbstractGainControl;
import net.sf.fmj.mf.media.content.unknown.MFPlayer;
import net.sf.fmj.utility.ExceptionUtils;
import net.sf.fmj.utility.LoggerSingleton;
import net.sf.fmj.utility.URLUtils;
import net.sf.jdshow.ComException;

public class Handler
extends AbstractPlayer {
    private static final ExecutorService executorService = ExecutorServiceManager.getExecutorService();
    private static final Logger logger = LoggerSingleton.logger;
    private static final boolean TRACE = true;
    private volatile String fileUrl;
    private MFPlayer mfPlayer;
    private MFPlayer.MFPlayerListener mfPlayerListener = new MediaFoundationListener();
    private final Canvas renderer;
    private ComponentListener componentListener;

    public Handler(Canvas renderer) {
        this.renderer = renderer;
    }

    public void setSource(final DataSource source) throws IncompatibleSourceException {
        Future<Void> future = executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                logger.fine("DataSource: " + source);
                if (!source.getLocator().getProtocol().equals("file")) {
                    throw new IncompatibleSourceException("Only file URLs supported: " + source);
                }
                String path = URLUtils.extractValidPathFromFileUrl(source.getLocator().toExternalForm());
                if (path == null) {
                    throw new IncompatibleSourceException("Unable to extract valid file path from URL: " + source.getLocator().toExternalForm());
                }
                try {
                    path = new File(path).getCanonicalPath();
                }
                catch (IOException e1) {
                    String msg = "Unable to get canonical path from " + path + ": " + e1;
                    logger.log(Level.WARNING, msg, e1);
                    throw new IncompatibleSourceException(e1.toString() + " \n" + ExceptionUtils.getStackTrace(e1));
                }
                logger.info("Path: " + path);
                File file = new File(path);
                if (!file.exists()) {
                    throw new IncompatibleSourceException("File must exist to be played");
                }
                Handler.this.fileUrl = URLUtils.extractValidPathFromFileUrl(URLUtils.createUrlStr(file));
                Handler.this.mfPlayer = MFPlayer.getInstance();
                long hwnd = 0L;
                try {
                    hwnd = Native.getComponentID(Handler.this.renderer);
                }
                catch (UnsatisfiedLinkError e) {
                    throw new IncompatibleSourceException(e.toString() + " \n" + ExceptionUtils.getStackTrace(e));
                }
                int result = Handler.this.mfPlayer.synchStartPlayer(Handler.this.fileUrl, hwnd);
                if (Handler.this.failed(result)) {
                    throw new IncompatibleSourceException("File not MediaFoundation playable: " + Handler.this.fileUrl);
                }
                long[] prefSize = new long[2];
                Handler.this.mfPlayer.getNativeSize(prefSize);
                final int width = (int)prefSize[0];
                final int height = (int)prefSize[1];
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (width != 0 && height != 0) {
                            Handler.this.renderer.setPreferredSize(new Dimension(width, height));
                        }
                        Handler.this.componentListener = new MFComponentListener();
                        Handler.this.renderer.addComponentListener(Handler.this.componentListener);
                    }
                });
                Handler.this.mfPlayer.addMFPlayerListener(Handler.this.mfPlayerListener);
                Handler.super.setSource(source);
                return null;
            }
        });
        try {
            future.get();
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, "" + e, e);
            throw new IncompatibleSourceException(e.toString() + " \n" + ExceptionUtils.getStackTrace(e));
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IncompatibleSourceException) {
                throw (IncompatibleSourceException)e.getCause();
            }
            logger.log(Level.WARNING, "" + e, e);
            throw new IncompatibleSourceException(e.toString() + " \n" + ExceptionUtils.getStackTrace(e));
        }
        this.setGainControl(new MFGainControl());
        this.postStartEvent();
    }

    public void doPlayerClose() {
    }

    public boolean doPlayerDeallocate() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (Handler.this.componentListener != null) {
                    Handler.this.renderer.removeComponentListener(Handler.this.componentListener);
                }
            }
        });
        Future<?> future = executorService.submit(new Runnable(){

            public void run() {
                Handler.this.mfPlayer.removeMFPlayerListener(Handler.this.mfPlayerListener);
                Handler.this.mfPlayer.killPlayer();
            }
        });
        try {
            future.get();
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, "" + e, e);
            ExceptionUtils.reportOrReturn(e);
            return true;
        }
        catch (ExecutionException e) {
            logger.log(Level.WARNING, "" + e, e);
            ExceptionUtils.reportOrReturn(e.getCause());
            return true;
        }
        return true;
    }

    public boolean doPlayerPrefetch() {
        return true;
    }

    public boolean doPlayerRealize() {
        return true;
    }

    public void doPlayerSetMediaTime(final Time t) {
        logger.info("Handler.doPlayerSetMediaTime");
        Future<?> future = executorService.submit(new Runnable(){

            public void run() {
                try {
                    long mfTime = t.getNanoseconds() / 100L;
                    int hr = Handler.this.mfPlayer.setPosition(mfTime);
                    if (Handler.this.failed(hr)) {
                        throw new ComException(hr);
                    }
                }
                catch (ComException e) {
                    logger.log(Level.WARNING, "" + e, e);
                }
            }
        });
        try {
            future.get();
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, "" + e, e);
            ExceptionUtils.reportOrReturn(e);
        }
        catch (ExecutionException e) {
            logger.log(Level.WARNING, "" + e, e);
            ExceptionUtils.reportOrReturn(e.getCause());
        }
    }

    public float doPlayerSetRate(final float rate) {
        Future<Float> future = executorService.submit(new Callable<Float>(){

            @Override
            public Float call() {
                logger.fine("Handler.doPlayerSetRate " + rate);
                return Float.valueOf(rate);
            }
        });
        try {
            return future.get().floatValue();
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, "" + e, e);
            ExceptionUtils.reportOrReturn(e);
            return this.getRate();
        }
        catch (ExecutionException e) {
            logger.log(Level.WARNING, "" + e, e);
            ExceptionUtils.reportOrReturn(e.getCause());
            return this.getRate();
        }
    }

    public boolean doPlayerStop() {
        Future<Boolean> future = executorService.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                logger.info("Handler.doPlayerStop");
                int hr = Handler.this.mfPlayer.pause();
                if (Handler.this.failed(hr)) {
                    return false;
                }
                return true;
            }
        });
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, "" + e, e);
            ExceptionUtils.reportOrReturn(e);
            return false;
        }
        catch (ExecutionException e) {
            logger.log(Level.WARNING, "" + e, e);
            ExceptionUtils.reportOrReturn(e.getCause());
            return false;
        }
    }

    public boolean doPlayerSyncStart(final Time t) {
        Future<Boolean> future = executorService.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                logger.info("Handler.doPlayerSyncStart" + t);
                int hr = Handler.this.mfPlayer.resume();
                if (Handler.this.failed(hr)) {
                    return false;
                }
                return true;
            }
        });
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, "" + e, e);
            ExceptionUtils.reportOrReturn(e);
            return false;
        }
        catch (ExecutionException e) {
            logger.log(Level.WARNING, "" + e, e);
            ExceptionUtils.reportOrReturn(e.getCause());
            return false;
        }
    }

    public Time getPlayerDuration() {
        Future<Time> future = executorService.submit(new Callable<Time>(){

            @Override
            public Time call() {
                try {
                    long[] duration = new long[1];
                    int hr = Handler.this.mfPlayer.getDuration(duration);
                    if (Handler.this.failed(hr)) {
                        throw new ComException(hr);
                    }
                    return new Time(duration[0] * 100L);
                }
                catch (ComException e) {
                    logger.log(Level.WARNING, "" + e, e);
                    return Duration.DURATION_UNKNOWN;
                }
            }
        });
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, "" + e, e);
            ExceptionUtils.reportOrReturn(e);
            return DURATION_UNKNOWN;
        }
        catch (ExecutionException e) {
            logger.log(Level.WARNING, "" + e, e);
            ExceptionUtils.reportOrReturn(e.getCause());
            return DURATION_UNKNOWN;
        }
    }

    public Time getMediaTime() {
        Future<Time> future = executorService.submit(new Callable<Time>(){

            @Override
            public Time call() {
                try {
                    long[] position = new long[1];
                    int hr = Handler.this.mfPlayer.getPosition(position);
                    if (Handler.this.failed(hr)) {
                        throw new ComException(hr);
                    }
                    return new Time(position[0] * 100L);
                }
                catch (ComException e) {
                    logger.log(Level.WARNING, "" + e, e);
                    return Duration.DURATION_UNKNOWN;
                }
            }
        });
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, "" + e, e);
            ExceptionUtils.reportOrReturn(e);
            return DURATION_UNKNOWN;
        }
        catch (ExecutionException e) {
            logger.log(Level.WARNING, "" + e, e);
            ExceptionUtils.reportOrReturn(e.getCause());
            return DURATION_UNKNOWN;
        }
    }

    public Time getPlayerStartLatency() {
        return new Time(0L);
    }

    public Component getVisualComponent() {
        return this.renderer;
    }

    public Component getControlPanelComponent() {
        Component c = super.getControlPanelComponent();
        if (c == null) {
            c = ControlPanelFactorySingleton.getInstance().getControlPanelComponent(this);
            this.setControlPanelComponent(c);
        }
        return c;
    }

    private boolean failed(int hr) {
        return hr < 0;
    }

    private class MFComponentListener
    extends ComponentAdapter {
        private MFComponentListener() {
        }

        public void componentResized(ComponentEvent e) {
            if (Handler.this.mfPlayer != null) {
                Handler.this.mfPlayer.update();
            }
        }

        public void componentMoved(ComponentEvent e) {
            if (Handler.this.mfPlayer != null) {
                Handler.this.mfPlayer.update();
            }
        }
    }

    private class MediaFoundationListener
    implements MFPlayer.MFPlayerListener {
        private MediaFoundationListener() {
        }

        public void statusChanged(final int status) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    switch (status) {
                        case -1: {
                            break;
                        }
                        case 0: {
                            Handler.this.setState(500);
                            break;
                        }
                        case 1: {
                            Handler.this.setState(600);
                            break;
                        }
                        case 2: {
                            Handler.this.postEndOfMediaEvent();
                        }
                    }
                }
            });
        }
    }

    private class MFGainControl
    extends AbstractGainControl {
        private static final long DS_MINIMUM_VOLUME = -10000L;

        private MFGainControl() {
        }

        public float getLevel() {
            Future<Float> future = executorService.submit(new Callable<Float>(){

                @Override
                public Float call() throws ComException {
                    float[] vol = new float[1];
                    int hr = Handler.this.mfPlayer.getVolume(vol);
                    if (Handler.this.failed(hr)) {
                        throw new ComException(hr);
                    }
                    return Float.valueOf(vol[0]);
                }
            });
            try {
                return future.get().floatValue();
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, "basicAudio.get_Volume failed", e);
                ExceptionUtils.reportOrReturn(e);
                return 0.0f;
            }
            catch (ExecutionException e) {
                logger.log(Level.WARNING, "basicAudio.get_Volume failed", e);
                ExceptionUtils.reportOrReturn(e.getCause());
                return 0.0f;
            }
        }

        public float setLevel(final float level) {
            Future<Float> future = executorService.submit(new Callable<Float>(){

                @Override
                public Float call() throws ComException {
                    int hr = Handler.this.mfPlayer.setVolume(level);
                    if (Handler.this.failed(hr)) {
                        throw new ComException(hr);
                    }
                    return Float.valueOf(level);
                }
            });
            try {
                future.get();
                this.notifyListenersGainChangeEvent();
                return level;
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, "basicAudio.put_Volume failed", e);
                ExceptionUtils.reportOrReturn(e);
                return level;
            }
            catch (ExecutionException e) {
                logger.log(Level.WARNING, "basicAudio.put_Volume failed", e);
                ExceptionUtils.reportOrReturn(e.getCause());
                return level;
            }
        }
    }
}

