/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.utility;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.UndeclaredThrowableException;

public class ExceptionUtils {
    private ExceptionUtils() {
    }

    public static void rethrow(Throwable t) {
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new UndeclaredThrowableException(t);
    }

    public static Throwable reportOrReturn(Throwable t) {
        Thread.UncaughtExceptionHandler handler = Thread.currentThread().getUncaughtExceptionHandler();
        if (handler == null) {
            handler = Thread.getDefaultUncaughtExceptionHandler();
        }
        if (handler != null) {
            handler.uncaughtException(Thread.currentThread(), t);
            return null;
        }
        return t;
    }

    public static void reportOrRethrow(Throwable t) {
        Thread.UncaughtExceptionHandler handler = Thread.currentThread().getUncaughtExceptionHandler();
        if (handler == null) {
            handler = Thread.getDefaultUncaughtExceptionHandler();
        }
        if (handler != null) {
            handler.uncaughtException(Thread.currentThread(), t);
        } else {
            ExceptionUtils.rethrow(t);
        }
    }

    public static String getStackTrace(Throwable aThrowable) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        aThrowable.printStackTrace(printWriter);
        return ((Object)result).toString();
    }
}

