/*
 * Decompiled with CFR 0.152.
 */
package org.bushe.swing.event;

import java.lang.reflect.Type;
import java.util.List;
import java.util.regex.Pattern;
import org.bushe.swing.event.EventService;
import org.bushe.swing.event.EventServiceLocator;
import org.bushe.swing.event.EventSubscriber;
import org.bushe.swing.event.EventTopicSubscriber;
import org.bushe.swing.event.VetoEventListener;
import org.bushe.swing.event.VetoTopicEventListener;

public class EventBus {
    private static EventService globalEventService = EventServiceLocator.getSwingEventService();

    public static EventService getGlobalEventService() {
        return globalEventService;
    }

    public static void publish(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Can't publish null.");
        }
        globalEventService.publish(object);
    }

    public static void publish(String string, Object object) {
        if (string == null) {
            throw new IllegalArgumentException("Can't publish to null topic.");
        }
        globalEventService.publish(string, object);
    }

    public static void publish(Type type, Object object) {
        if (type == null) {
            throw new IllegalArgumentException("Can't publish to null type.");
        }
        globalEventService.publish(type, object);
    }

    public static boolean subscribe(Class clazz, EventSubscriber eventSubscriber) {
        return globalEventService.subscribe(clazz, eventSubscriber);
    }

    public static boolean subscribe(Type type, EventSubscriber eventSubscriber) {
        return globalEventService.subscribe(type, eventSubscriber);
    }

    public static boolean subscribeExactly(Class clazz, EventSubscriber eventSubscriber) {
        return globalEventService.subscribeExactly(clazz, eventSubscriber);
    }

    public static boolean subscribe(String string, EventTopicSubscriber eventTopicSubscriber) {
        return globalEventService.subscribe(string, eventTopicSubscriber);
    }

    public static boolean subscribe(Pattern pattern, EventTopicSubscriber eventTopicSubscriber) {
        return globalEventService.subscribe(pattern, eventTopicSubscriber);
    }

    public static boolean subscribeStrongly(Class clazz, EventSubscriber eventSubscriber) {
        return globalEventService.subscribeStrongly(clazz, eventSubscriber);
    }

    public static boolean subscribeExactlyStrongly(Class clazz, EventSubscriber eventSubscriber) {
        return globalEventService.subscribeExactlyStrongly(clazz, eventSubscriber);
    }

    public static boolean subscribeStrongly(String string, EventTopicSubscriber eventTopicSubscriber) {
        return globalEventService.subscribeStrongly(string, eventTopicSubscriber);
    }

    public static boolean subscribeStrongly(Pattern pattern, EventTopicSubscriber eventTopicSubscriber) {
        return globalEventService.subscribeStrongly(pattern, eventTopicSubscriber);
    }

    public static boolean unsubscribe(Class clazz, EventSubscriber eventSubscriber) {
        return globalEventService.unsubscribe(clazz, eventSubscriber);
    }

    public static boolean unsubscribeExactly(Class clazz, EventSubscriber eventSubscriber) {
        return globalEventService.unsubscribeExactly(clazz, eventSubscriber);
    }

    public static boolean unsubscribe(String string, EventTopicSubscriber eventTopicSubscriber) {
        return globalEventService.unsubscribe(string, eventTopicSubscriber);
    }

    public static boolean unsubscribe(Pattern pattern, EventTopicSubscriber eventTopicSubscriber) {
        return globalEventService.unsubscribe(pattern, eventTopicSubscriber);
    }

    public static boolean unsubscribe(Class clazz, Object object) {
        return globalEventService.unsubscribe(clazz, object);
    }

    public static boolean unsubscribeExactly(Class clazz, Object object) {
        return globalEventService.unsubscribeExactly(clazz, object);
    }

    public static boolean unsubscribe(String string, Object object) {
        return globalEventService.unsubscribe(string, object);
    }

    public static boolean unsubscribe(Pattern pattern, Object object) {
        return globalEventService.unsubscribe(pattern, object);
    }

    public static boolean subscribeVetoListener(Class clazz, VetoEventListener vetoEventListener) {
        return globalEventService.subscribeVetoListener(clazz, vetoEventListener);
    }

    public static boolean subscribeVetoListenerExactly(Class clazz, VetoEventListener vetoEventListener) {
        return globalEventService.subscribeVetoListenerExactly(clazz, vetoEventListener);
    }

    public static boolean subscribeVetoListener(String string, VetoTopicEventListener vetoTopicEventListener) {
        return globalEventService.subscribeVetoListener(string, vetoTopicEventListener);
    }

    public static boolean subscribeVetoListener(Pattern pattern, VetoTopicEventListener vetoTopicEventListener) {
        return globalEventService.subscribeVetoListener(pattern, vetoTopicEventListener);
    }

    public static boolean subscribeVetoListenerStrongly(Class clazz, VetoEventListener vetoEventListener) {
        return globalEventService.subscribeVetoListenerStrongly(clazz, vetoEventListener);
    }

    public static boolean subscribeVetoListenerExactlyStrongly(Class clazz, VetoEventListener vetoEventListener) {
        return globalEventService.subscribeVetoListenerExactlyStrongly(clazz, vetoEventListener);
    }

    public static boolean subscribeVetoListenerStrongly(String string, VetoTopicEventListener vetoTopicEventListener) {
        return globalEventService.subscribeVetoListenerStrongly(string, vetoTopicEventListener);
    }

    public static boolean subscribeVetoListenerStrongly(Pattern pattern, VetoTopicEventListener vetoTopicEventListener) {
        return globalEventService.subscribeVetoListenerStrongly(pattern, vetoTopicEventListener);
    }

    public static boolean unsubscribeVetoListener(Class clazz, VetoEventListener vetoEventListener) {
        return globalEventService.unsubscribeVetoListener(clazz, vetoEventListener);
    }

    public static boolean unsubscribeVetoListenerExactly(Class clazz, VetoEventListener vetoEventListener) {
        return globalEventService.unsubscribeVetoListenerExactly(clazz, vetoEventListener);
    }

    public static boolean unsubscribeVetoListener(String string, VetoTopicEventListener vetoTopicEventListener) {
        return globalEventService.unsubscribeVetoListener(string, vetoTopicEventListener);
    }

    public static boolean unsubscribeVetoListener(Pattern pattern, VetoTopicEventListener vetoTopicEventListener) {
        return globalEventService.unsubscribeVetoListener(pattern, vetoTopicEventListener);
    }

    public static List getSubscribers(Class clazz) {
        return globalEventService.getSubscribers(clazz);
    }

    public static List getSubscribersToClass(Class clazz) {
        return globalEventService.getSubscribersToClass(clazz);
    }

    public static List getSubscribersToExactClass(Class clazz) {
        return globalEventService.getSubscribersToExactClass(clazz);
    }

    public static List getSubscribers(String string) {
        return globalEventService.getSubscribers(string);
    }

    public static List getSubscribersToTopic(String string) {
        return globalEventService.getSubscribersToTopic(string);
    }

    public static List getSubscribersByPattern(String string) {
        return globalEventService.getSubscribersByPattern(string);
    }

    public static List getVetoSubscribers(Class clazz) {
        return globalEventService.getVetoSubscribers(clazz);
    }

    public static List getVetoSubscribersToExactClass(Class clazz) {
        return globalEventService.getVetoSubscribersToExactClass(clazz);
    }

    public static List getVetoSubscribers(String string) {
        return globalEventService.getVetoSubscribers(string);
    }

    public static List getVetoSubscribersToClass(Class clazz) {
        return globalEventService.getVetoSubscribersToClass(clazz);
    }

    public static List getVetoSubscribers(Pattern pattern) {
        return globalEventService.getVetoSubscribers(pattern);
    }

    public static void clearAllSubscribers() {
        globalEventService.clearAllSubscribers();
    }

    public static void setDefaultCacheSizePerClassOrTopic(int n) {
        globalEventService.setDefaultCacheSizePerClassOrTopic(n);
    }

    public static int getDefaultCacheSizePerClassOrTopic() {
        return globalEventService.getDefaultCacheSizePerClassOrTopic();
    }

    public static void setCacheSizeForEventClass(Class clazz, int n) {
        globalEventService.setCacheSizeForEventClass(clazz, n);
    }

    public static int getCacheSizeForEventClass(Class clazz) {
        return globalEventService.getCacheSizeForEventClass(clazz);
    }

    public static void setCacheSizeForTopic(String string, int n) {
        globalEventService.setCacheSizeForTopic(string, n);
    }

    public static void setCacheSizeForTopic(Pattern pattern, int n) {
        globalEventService.setCacheSizeForTopic(pattern, n);
    }

    public static int getCacheSizeForTopic(String string) {
        return globalEventService.getCacheSizeForTopic(string);
    }

    public static Object getLastEvent(Class clazz) {
        return globalEventService.getLastEvent(clazz);
    }

    public static List getCachedEvents(Class clazz) {
        return globalEventService.getCachedEvents(clazz);
    }

    public static Object getLastTopicData(String string) {
        return globalEventService.getLastTopicData(string);
    }

    public static List getCachedTopicData(String string) {
        return globalEventService.getCachedTopicData(string);
    }

    public static void clearCache(Class clazz) {
        globalEventService.clearCache(clazz);
    }

    public static void clearCache(String string) {
        globalEventService.clearCache(string);
    }

    public static void clearCache(Pattern pattern) {
        globalEventService.clearCache(pattern);
    }

    public static void clearCache() {
        globalEventService.clearCache();
    }
}

