/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.io;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import org.jaudiotagger.audio.asf.data.Chunk;
import org.jaudiotagger.audio.asf.data.EncodingChunk;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.io.ChunkReader;
import org.jaudiotagger.audio.asf.util.Utils;

class EncodingChunkReader
implements ChunkReader {
    protected EncodingChunkReader() {
    }

    @Override
    public boolean canFail() {
        return false;
    }

    @Override
    public GUID getApplyingId() {
        return GUID.GUID_ENCODING;
    }

    @Override
    public Chunk read(GUID guid, InputStream stream, long chunkStart) throws IOException {
        BigInteger chunkLen = Utils.readBig64(stream);
        EncodingChunk result = new EncodingChunk(chunkLen);
        int readBytes = 24;
        stream.skip(20L);
        readBytes += 20;
        int stringCount = Utils.readUINT16(stream);
        readBytes += 2;
        for (int i = 0; i < stringCount; ++i) {
            String curr = Utils.readCharacterSizedString(stream);
            result.addString(curr);
            readBytes += 4 + 2 * curr.length();
        }
        stream.skip(chunkLen.longValue() - (long)readBytes);
        result.setPosition(chunkStart);
        return result;
    }
}

