/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.ogg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.CannotWriteException;
import org.jaudiotagger.audio.ogg.OggVorbisCommentTagCreator;
import org.jaudiotagger.audio.ogg.OggVorbisTagReader;
import org.jaudiotagger.audio.ogg.util.OggCRCFactory;
import org.jaudiotagger.audio.ogg.util.OggPageHeader;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentTag;

public class OggVorbisTagWriter {
    private OggVorbisCommentTagCreator tc = new OggVorbisCommentTagCreator();
    private OggVorbisTagReader reader = new OggVorbisTagReader();

    public void delete(RandomAccessFile raf, RandomAccessFile tempRaf) throws IOException, CannotReadException, CannotWriteException {
        VorbisCommentTag tag = null;
        try {
            tag = (VorbisCommentTag)this.reader.read(raf);
        }
        catch (CannotReadException e) {
            this.write(VorbisCommentTag.createNewTag(), raf, tempRaf);
            return;
        }
        VorbisCommentTag emptyTag = VorbisCommentTag.createNewTag();
        raf.seek(0L);
        this.write(emptyTag, raf, tempRaf);
    }

    public void write(Tag tag, RandomAccessFile raf, RandomAccessFile rafTemp) throws CannotReadException, CannotWriteException, IOException {
        OggPageHeader pageHeader = OggPageHeader.read(raf);
        raf.seek(0L);
        rafTemp.getChannel().transferFrom(raf.getChannel(), 0L, pageHeader.getPageLength() + 27 + pageHeader.getSegmentTable().length);
        rafTemp.skipBytes(pageHeader.getPageLength() + 27 + pageHeader.getSegmentTable().length);
        OggPageHeader secondPageHeader = OggPageHeader.read(raf);
        long secondPageHeaderEndPos = raf.getFilePointer();
        raf.seek(0L);
        OggVorbisTagReader.OggVorbisHeaderSizes vorbisHeaderSizes = this.reader.readOggVorbisHeaderSizes(raf);
        ByteBuffer newComment = this.tc.convert(tag);
        int newCommentLength = newComment.capacity();
        int newSecondPageDataLength = vorbisHeaderSizes.getSetupHeaderSize() + newCommentLength + vorbisHeaderSizes.getExtraPacketDataSize();
        if (this.isCommentAndSetupHeaderFitsOnASinglePage(newCommentLength, vorbisHeaderSizes.getSetupHeaderSize(), vorbisHeaderSizes.getExtraPacketList())) {
            if (secondPageHeader.getPageLength() < 65025 && (secondPageHeader.getPacketList().size() == 2 && !secondPageHeader.isLastPacketIncomplete() || secondPageHeader.getPacketList().size() > 2)) {
                this.replaceSecondPageOnly(vorbisHeaderSizes, newCommentLength, newSecondPageDataLength, secondPageHeader, newComment, secondPageHeaderEndPos, raf, rafTemp);
            } else {
                this.replaceSecondPageAndRenumberPageSeqs(vorbisHeaderSizes, newCommentLength, newSecondPageDataLength, secondPageHeader, newComment, raf, rafTemp);
            }
        } else {
            this.replacePagesAndRenumberPageSeqs(vorbisHeaderSizes, newCommentLength, secondPageHeader, newComment, raf, rafTemp);
        }
    }

    private void replaceSecondPageOnly(OggVorbisTagReader.OggVorbisHeaderSizes vorbisHeaderSizes, int newCommentLength, int newSecondPageLength, OggPageHeader secondPageHeader, ByteBuffer newComment, long secondPageHeaderEndPos, RandomAccessFile raf, RandomAccessFile rafTemp) throws IOException {
        byte[] segmentTable = this.createSegmentTable(newCommentLength, vorbisHeaderSizes.getSetupHeaderSize(), vorbisHeaderSizes.getExtraPacketList());
        int newSecondPageHeaderLength = 27 + segmentTable.length;
        ByteBuffer secondPageBuffer = ByteBuffer.allocate(newSecondPageLength + newSecondPageHeaderLength);
        secondPageBuffer.order(ByteOrder.LITTLE_ENDIAN);
        secondPageBuffer.put(secondPageHeader.getRawHeaderData(), 0, 26);
        secondPageBuffer.put((byte)segmentTable.length);
        for (int i = 0; i < segmentTable.length; ++i) {
            secondPageBuffer.put(segmentTable[i]);
        }
        secondPageBuffer.put(newComment);
        raf.seek(secondPageHeaderEndPos);
        raf.skipBytes(vorbisHeaderSizes.getCommentHeaderSize());
        raf.getChannel().read(secondPageBuffer);
        secondPageBuffer.putInt(22, 0);
        byte[] crc = OggCRCFactory.computeCRC(secondPageBuffer.array());
        for (int i = 0; i < crc.length; ++i) {
            secondPageBuffer.put(22 + i, crc[i]);
        }
        secondPageBuffer.rewind();
        rafTemp.getChannel().write(secondPageBuffer);
        rafTemp.getChannel().transferFrom(raf.getChannel(), rafTemp.getFilePointer(), raf.length() - raf.getFilePointer());
    }

    private void replaceSecondPageAndRenumberPageSeqs(OggVorbisTagReader.OggVorbisHeaderSizes originalHeaderSizes, int newCommentLength, int newSecondPageLength, OggPageHeader secondPageHeader, ByteBuffer newComment, RandomAccessFile raf, RandomAccessFile rafTemp) throws IOException, CannotReadException, CannotWriteException {
        byte[] segmentTable = this.createSegmentTable(newCommentLength, originalHeaderSizes.getSetupHeaderSize(), originalHeaderSizes.getExtraPacketList());
        int newSecondPageHeaderLength = 27 + segmentTable.length;
        ByteBuffer secondPageBuffer = ByteBuffer.allocate(newSecondPageLength + newSecondPageHeaderLength);
        secondPageBuffer.put(secondPageHeader.getRawHeaderData(), 0, 26);
        secondPageBuffer.order(ByteOrder.LITTLE_ENDIAN);
        secondPageBuffer.put((byte)segmentTable.length);
        for (int i = 0; i < segmentTable.length; ++i) {
            secondPageBuffer.put(segmentTable[i]);
        }
        secondPageBuffer.put(newComment);
        int pageSequence = secondPageHeader.getPageSequence();
        byte[] setupHeaderData = this.reader.convertToVorbisSetupHeaderPacketAndAdditionalPackets(originalHeaderSizes.getSetupHeaderStartPosition(), raf);
        secondPageBuffer.put(setupHeaderData);
        secondPageBuffer.putInt(22, 0);
        byte[] crc = OggCRCFactory.computeCRC(secondPageBuffer.array());
        for (int i = 0; i < crc.length; ++i) {
            secondPageBuffer.put(22 + i, crc[i]);
        }
        secondPageBuffer.rewind();
        rafTemp.getChannel().write(secondPageBuffer);
        long startAudio = raf.getFilePointer();
        long startAudioWritten = rafTemp.getFilePointer();
        while (raf.getFilePointer() < raf.length()) {
            OggPageHeader nextPage = OggPageHeader.read(raf);
            ByteBuffer nextPageHeaderBuffer = ByteBuffer.allocate(nextPage.getRawHeaderData().length + nextPage.getPageLength());
            nextPageHeaderBuffer.order(ByteOrder.LITTLE_ENDIAN);
            nextPageHeaderBuffer.put(nextPage.getRawHeaderData());
            raf.getChannel().read(nextPageHeaderBuffer);
            nextPageHeaderBuffer.putInt(18, ++pageSequence);
            nextPageHeaderBuffer.putInt(22, 0);
            crc = OggCRCFactory.computeCRC(nextPageHeaderBuffer.array());
            for (int i = 0; i < crc.length; ++i) {
                nextPageHeaderBuffer.put(22 + i, crc[i]);
            }
            nextPageHeaderBuffer.rewind();
            rafTemp.getChannel().write(nextPageHeaderBuffer);
        }
        if (raf.length() - startAudio != rafTemp.length() - startAudioWritten) {
            throw new CannotWriteException("File written counts dont match, file not written");
        }
    }

    private void replacePagesAndRenumberPageSeqs(OggVorbisTagReader.OggVorbisHeaderSizes originalHeaderSizes, int newCommentLength, OggPageHeader secondPageHeader, ByteBuffer newComment, RandomAccessFile raf, RandomAccessFile rafTemp) throws IOException, CannotReadException, CannotWriteException {
        byte[] segmentTable;
        int pageSequence = secondPageHeader.getPageSequence();
        int noOfPagesNeededForComment = newCommentLength / 65025;
        int newCommentOffset = 0;
        for (int i = 0; i < noOfPagesNeededForComment; ++i) {
            segmentTable = this.createSegments(65025, false);
            int pageHeaderLength = 27 + segmentTable.length;
            ByteBuffer pageBuffer = ByteBuffer.allocate(pageHeaderLength + 65025);
            pageBuffer.order(ByteOrder.LITTLE_ENDIAN);
            pageBuffer.put(secondPageHeader.getRawHeaderData(), 0, 26);
            pageBuffer.put((byte)segmentTable.length);
            for (int j = 0; j < segmentTable.length; ++j) {
                pageBuffer.put(segmentTable[j]);
            }
            pageBuffer.put(newComment.array(), newCommentOffset, 65025);
            pageBuffer.putInt(18, pageSequence);
            ++pageSequence;
            if (i != 0) {
                pageBuffer.put(5, OggPageHeader.HeaderTypeFlag.CONTINUED_PACKET.getFileValue());
            }
            pageBuffer.putInt(22, 0);
            byte[] crc = OggCRCFactory.computeCRC(pageBuffer.array());
            for (int j = 0; j < crc.length; ++j) {
                pageBuffer.put(22 + j, crc[j]);
            }
            pageBuffer.rewind();
            rafTemp.getChannel().write(pageBuffer);
            newCommentOffset += 65025;
        }
        int lastPageCommentPacketSize = newCommentLength % 65025;
        if (!this.isCommentAndSetupHeaderFitsOnASinglePage(lastPageCommentPacketSize, originalHeaderSizes.getSetupHeaderSize(), originalHeaderSizes.getExtraPacketList())) {
            int i;
            byte[] commentSegmentTable = this.createSegments(lastPageCommentPacketSize, true);
            int remainingSegmentSlots = 255 - commentSegmentTable.length;
            int firstHalfOfHeaderSize = remainingSegmentSlots * 255;
            byte[] firstHalfofSegmentHeaderTable = this.createSegments(firstHalfOfHeaderSize, false);
            byte[] segmentTable2 = this.createSegmentTable(lastPageCommentPacketSize, firstHalfOfHeaderSize, new ArrayList<OggPageHeader.PacketStartAndLength>());
            int lastCommentHeaderLength = 27 + commentSegmentTable.length + firstHalfofSegmentHeaderTable.length;
            ByteBuffer lastCommentHeaderBuffer = ByteBuffer.allocate(lastCommentHeaderLength + lastPageCommentPacketSize + firstHalfOfHeaderSize);
            lastCommentHeaderBuffer.put(secondPageHeader.getRawHeaderData(), 0, 26);
            lastCommentHeaderBuffer.order(ByteOrder.LITTLE_ENDIAN);
            lastCommentHeaderBuffer.put((byte)segmentTable2.length);
            for (int i2 = 0; i2 < segmentTable2.length; ++i2) {
                lastCommentHeaderBuffer.put(segmentTable2[i2]);
            }
            lastCommentHeaderBuffer.put(newComment.array(), newCommentOffset, lastPageCommentPacketSize);
            byte[] setupHeaderData = this.reader.convertToVorbisSetupHeaderPacketAndAdditionalPackets(originalHeaderSizes.getSetupHeaderStartPosition(), raf);
            int copyAmount = setupHeaderData.length;
            if (setupHeaderData.length > lastCommentHeaderBuffer.remaining()) {
                copyAmount = lastCommentHeaderBuffer.remaining();
            }
            lastCommentHeaderBuffer.put(setupHeaderData, 0, copyAmount);
            lastCommentHeaderBuffer.putInt(18, pageSequence);
            lastCommentHeaderBuffer.put(5, OggPageHeader.HeaderTypeFlag.CONTINUED_PACKET.getFileValue());
            ++pageSequence;
            lastCommentHeaderBuffer.putInt(22, 0);
            byte[] crc = OggCRCFactory.computeCRC(lastCommentHeaderBuffer.array());
            for (int i3 = 0; i3 < crc.length; ++i3) {
                lastCommentHeaderBuffer.put(22 + i3, crc[i3]);
            }
            lastCommentHeaderBuffer.rewind();
            rafTemp.getChannel().write(lastCommentHeaderBuffer);
            int secondHalfOfHeaderSize = originalHeaderSizes.getSetupHeaderSize() - firstHalfOfHeaderSize;
            segmentTable2 = this.createSegmentTable(secondHalfOfHeaderSize, originalHeaderSizes.getExtraPacketList());
            int lastSetupHeaderLength = 27 + segmentTable2.length;
            ByteBuffer lastSetupHeaderBuffer = ByteBuffer.allocate(lastSetupHeaderLength + secondHalfOfHeaderSize + originalHeaderSizes.getExtraPacketDataSize());
            lastSetupHeaderBuffer.put(secondPageHeader.getRawHeaderData(), 0, 26);
            lastSetupHeaderBuffer.order(ByteOrder.LITTLE_ENDIAN);
            lastSetupHeaderBuffer.put((byte)segmentTable2.length);
            for (i = 0; i < segmentTable2.length; ++i) {
                lastSetupHeaderBuffer.put(segmentTable2[i]);
            }
            lastSetupHeaderBuffer.put(setupHeaderData, copyAmount, setupHeaderData.length - copyAmount);
            lastSetupHeaderBuffer.putInt(18, pageSequence);
            lastSetupHeaderBuffer.put(5, OggPageHeader.HeaderTypeFlag.CONTINUED_PACKET.getFileValue());
            lastSetupHeaderBuffer.putInt(22, 0);
            crc = OggCRCFactory.computeCRC(lastSetupHeaderBuffer.array());
            for (i = 0; i < crc.length; ++i) {
                lastSetupHeaderBuffer.put(22 + i, crc[i]);
            }
            lastSetupHeaderBuffer.rewind();
            rafTemp.getChannel().write(lastSetupHeaderBuffer);
        } else {
            segmentTable = this.createSegmentTable(lastPageCommentPacketSize, originalHeaderSizes.getSetupHeaderSize(), originalHeaderSizes.getExtraPacketList());
            int lastHeaderLength = 27 + segmentTable.length;
            ByteBuffer lastCommentHeaderBuffer = ByteBuffer.allocate(lastHeaderLength + lastPageCommentPacketSize + originalHeaderSizes.getExtraPacketDataSize() + originalHeaderSizes.getSetupHeaderSize());
            lastCommentHeaderBuffer.put(secondPageHeader.getRawHeaderData(), 0, 26);
            lastCommentHeaderBuffer.order(ByteOrder.LITTLE_ENDIAN);
            lastCommentHeaderBuffer.put((byte)segmentTable.length);
            for (int i = 0; i < segmentTable.length; ++i) {
                lastCommentHeaderBuffer.put(segmentTable[i]);
            }
            lastCommentHeaderBuffer.put(newComment.array(), newCommentOffset, lastPageCommentPacketSize);
            raf.seek(originalHeaderSizes.getSetupHeaderStartPosition());
            byte[] setupHeaderData = this.reader.convertToVorbisSetupHeaderPacketAndAdditionalPackets(originalHeaderSizes.getSetupHeaderStartPosition(), raf);
            lastCommentHeaderBuffer.put(setupHeaderData);
            lastCommentHeaderBuffer.putInt(18, pageSequence);
            lastCommentHeaderBuffer.put(5, OggPageHeader.HeaderTypeFlag.CONTINUED_PACKET.getFileValue());
            lastCommentHeaderBuffer.putInt(22, 0);
            byte[] crc = OggCRCFactory.computeCRC(lastCommentHeaderBuffer.array());
            for (int i = 0; i < crc.length; ++i) {
                lastCommentHeaderBuffer.put(22 + i, crc[i]);
            }
            lastCommentHeaderBuffer.rewind();
            rafTemp.getChannel().write(lastCommentHeaderBuffer);
        }
        long startAudio = raf.getFilePointer();
        long startAudioWritten = rafTemp.getFilePointer();
        while (raf.getFilePointer() < raf.length()) {
            OggPageHeader nextPage = OggPageHeader.read(raf);
            ByteBuffer nextPageHeaderBuffer = ByteBuffer.allocate(nextPage.getRawHeaderData().length + nextPage.getPageLength());
            nextPageHeaderBuffer.order(ByteOrder.LITTLE_ENDIAN);
            nextPageHeaderBuffer.put(nextPage.getRawHeaderData());
            raf.getChannel().read(nextPageHeaderBuffer);
            nextPageHeaderBuffer.putInt(18, ++pageSequence);
            nextPageHeaderBuffer.putInt(22, 0);
            byte[] crc = OggCRCFactory.computeCRC(nextPageHeaderBuffer.array());
            for (int i = 0; i < crc.length; ++i) {
                nextPageHeaderBuffer.put(22 + i, crc[i]);
            }
            nextPageHeaderBuffer.rewind();
            rafTemp.getChannel().write(nextPageHeaderBuffer);
        }
        if (raf.length() - startAudio != rafTemp.length() - startAudioWritten) {
            throw new CannotWriteException("File written counts dont macth, file not written");
        }
    }

    private byte[] createSegmentTable(int newCommentLength, int setupHeaderLength, List<OggPageHeader.PacketStartAndLength> extraPackets) {
        ByteArrayOutputStream resultBaos = new ByteArrayOutputStream();
        if (setupHeaderLength == 0) {
            byte[] newStart = this.createSegments(newCommentLength, false);
            return newStart;
        }
        byte[] newStart = this.createSegments(newCommentLength, true);
        byte[] restShouldBe = extraPackets.size() > 0 ? this.createSegments(setupHeaderLength, true) : this.createSegments(setupHeaderLength, false);
        try {
            resultBaos.write(newStart);
            resultBaos.write(restShouldBe);
            if (extraPackets.size() > 0) {
                for (OggPageHeader.PacketStartAndLength packet : extraPackets) {
                    byte[] nextPacket = this.createSegments(packet.getLength(), false);
                    resultBaos.write(nextPacket);
                }
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to create segment table:" + ioe.getMessage());
        }
        return resultBaos.toByteArray();
    }

    private byte[] createSegmentTable(int setupHeaderLength, List<OggPageHeader.PacketStartAndLength> extraPackets) {
        ByteArrayOutputStream resultBaos = new ByteArrayOutputStream();
        byte[] restShouldBe = this.createSegments(setupHeaderLength, true);
        try {
            resultBaos.write(restShouldBe);
            if (extraPackets.size() > 0) {
                for (OggPageHeader.PacketStartAndLength packet : extraPackets) {
                    byte[] nextPacket = this.createSegments(packet.getLength(), false);
                    resultBaos.write(nextPacket);
                }
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to create segment table:" + ioe.getMessage());
        }
        return resultBaos.toByteArray();
    }

    private byte[] createSegments(int length, boolean quitStream) {
        int i;
        byte[] result = new byte[length / 255 + (length % 255 == 0 && !quitStream ? 0 : 1)];
        for (i = 0; i < result.length - 1; ++i) {
            result[i] = -1;
        }
        result[result.length - 1] = (byte)(length - i * 255);
        return result;
    }

    private boolean isCommentAndSetupHeaderFitsOnASinglePage(int commentLength, int setupHeaderLength, List<OggPageHeader.PacketStartAndLength> extraPacketList) {
        int totalDataSize = 0;
        totalDataSize = commentLength / 255;
        if (commentLength % 255 == 0) {
            ++totalDataSize;
        }
        totalDataSize += setupHeaderLength / 255;
        if (setupHeaderLength % 255 == 0) {
            ++totalDataSize;
        }
        for (OggPageHeader.PacketStartAndLength extraPacket : extraPacketList) {
            totalDataSize += extraPacket.getLength() / 255;
            if (extraPacket.getLength() % 255 != 0) continue;
            ++totalDataSize;
        }
        return totalDataSize <= 255;
    }
}

