/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.datatype;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.imageio.ImageIO;
import org.jaudiotagger.tag.id3.valuepair.ImageFormats;

public class Artwork {
    private byte[] binaryData;
    private String mimeType;
    private String description;
    private boolean isLinked;
    private String imageUrl;
    private int pictureType;

    public byte[] getBinaryData() {
        return this.binaryData;
    }

    public void setBinaryData(byte[] binaryData) {
        this.binaryData = binaryData;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public BufferedImage getImage() throws IOException {
        BufferedImage bi = ImageIO.read(ImageIO.createImageInputStream(new ByteArrayInputStream(this.getBinaryData())));
        return bi;
    }

    public boolean isLinked() {
        return this.isLinked;
    }

    public void setLinked(boolean linked) {
        this.isLinked = linked;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public int getPictureType() {
        return this.pictureType;
    }

    public void setPictureType(int pictureType) {
        this.pictureType = pictureType;
    }

    public void setFromFile(File file) throws IOException {
        RandomAccessFile imageFile = new RandomAccessFile(file, "r");
        byte[] imagedata = new byte[(int)imageFile.length()];
        imageFile.read(imagedata);
        this.setBinaryData(imagedata);
        this.setMimeType(ImageFormats.getMimeTypeForBinarySignature(imagedata));
    }

    public static Artwork createArtworkFromFile(File file) throws IOException {
        Artwork artwork = new Artwork();
        artwork.setFromFile(file);
        return artwork;
    }
}

