/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.animation.transitions;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.transitions.ComponentState;
import org.jdesktop.animation.transitions.Effect;
import org.jdesktop.animation.transitions.EffectsManager;
import org.jdesktop.animation.transitions.effects.CompositeEffect;
import org.jdesktop.animation.transitions.effects.FadeIn;
import org.jdesktop.animation.transitions.effects.FadeOut;
import org.jdesktop.animation.transitions.effects.Move;
import org.jdesktop.animation.transitions.effects.Scale;
import org.jdesktop.animation.transitions.effects.Unchanging;

class AnimationState {
    private JComponent component;
    private ComponentState start;
    private ComponentState end;
    private Effect effect;

    AnimationState() {
    }

    AnimationState(ComponentState state, boolean isStart) {
        this.component = state.getComponent();
        if (isStart) {
            this.start = state;
        } else {
            this.end = state;
        }
    }

    AnimationState(JComponent component, boolean isStart) {
        this.component = component;
        ComponentState compState = new ComponentState(component);
        if (isStart) {
            this.start = compState;
        } else {
            this.end = compState;
        }
    }

    void setStart(ComponentState compState) {
        this.start = compState;
    }

    void setEnd(ComponentState compState) {
        this.end = compState;
    }

    ComponentState getStart() {
        return this.start;
    }

    ComponentState getEnd() {
        return this.end;
    }

    Component getComponent() {
        return this.component;
    }

    void init(Animator animator) {
        if (this.start == null) {
            this.effect = EffectsManager.getEffect(this.component, EffectsManager.TransitionType.APPEARING);
            if (this.effect == null) {
                this.effect = new FadeIn(this.end);
            } else {
                this.effect.setEnd(this.end);
            }
        } else if (this.end == null) {
            this.effect = EffectsManager.getEffect(this.component, EffectsManager.TransitionType.DISAPPEARING);
            if (this.effect == null) {
                this.effect = new FadeOut(this.start);
            } else {
                this.effect.setStart(this.start);
            }
        } else {
            this.effect = EffectsManager.getEffect(this.component, EffectsManager.TransitionType.CHANGING);
            if (this.effect == null) {
                boolean move = false;
                boolean scale = false;
                if (this.start.getX() != this.end.getX() || this.start.getY() != this.end.getY()) {
                    move = true;
                }
                if (this.start.getWidth() != this.end.getWidth() || this.start.getHeight() != this.end.getHeight()) {
                    scale = true;
                }
                if (move) {
                    if (scale) {
                        this.effect = new Move(this.start, this.end);
                        Scale scaleEffect = new Scale(this.start, this.end);
                        this.effect = new CompositeEffect(this.effect);
                        ((CompositeEffect)this.effect).addEffect(scaleEffect);
                    } else {
                        this.effect = new Move(this.start, this.end);
                    }
                } else {
                    this.effect = scale ? new Scale(this.start, this.end) : new Unchanging(this.start, this.end);
                }
            } else {
                this.effect.setStart(this.start);
                this.effect.setEnd(this.end);
            }
        }
        this.effect.init(animator, null);
    }

    void cleanup(Animator animator) {
        this.effect.cleanup(animator);
    }

    void paint(Graphics g) {
        if (this.effect != null) {
            Graphics2D g2d = (Graphics2D)g.create();
            this.effect.render(g2d);
            g2d.dispose();
        }
    }
}

