/*
 * Decompiled with CFR 0.152.
 */
package org.kc7bfi.jflac.sound.spi;

import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import org.kc7bfi.jflac.util.RingBuffer;

public abstract class RingedAudioInputStream
extends AudioInputStream {
    public static final int DEFAULT_BUFFER_SIZE = 2048;
    protected InputStream in;
    private final byte[] single = new byte[1];
    protected RingBuffer buffer = new RingBuffer();

    private void checkIfStillOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }

    public RingedAudioInputStream(InputStream in, AudioFormat format, long length) {
        this(in, format, length, 2048);
    }

    public RingedAudioInputStream(InputStream in, AudioFormat format, long length, int size) {
        this(in, format, length, size, size);
    }

    public RingedAudioInputStream(InputStream in, AudioFormat format, long length, int size, int presize) {
        super(in, format, length);
        this.in = in;
        if (format.getFrameSize() > 0) {
            this.buffer.resize(format.getFrameSize() * 2);
        }
    }

    protected void fill() throws IOException {
    }

    public synchronized int read() throws IOException {
        this.fill();
        if (this.buffer.get(this.single, 0, 1) == -1) {
            return -1;
        }
        return this.single[0] & 0xFF;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        this.checkIfStillOpen();
        this.fill();
        int bytesRead = this.buffer.get(b, off, len);
        return bytesRead;
    }

    public synchronized long skip(long n) throws IOException {
        this.checkIfStillOpen();
        throw new IOException("skip not supported");
    }

    public synchronized int available() throws IOException {
        this.checkIfStillOpen();
        this.fill();
        return this.buffer.getAvailable();
    }

    public synchronized void mark(int readlimit) {
    }

    public synchronized void reset() throws IOException {
        this.checkIfStillOpen();
        throw new IOException("reset not supported");
    }

    public boolean markSupported() {
        return false;
    }

    public synchronized void close() throws IOException {
        if (this.in == null) {
            return;
        }
        this.in.close();
        this.in = null;
    }
}

