/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.bittorrent.bencoding;

import java.io.EOFException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.limewire.bittorrent.bencoding.Token;
import org.limewire.util.BEncoder;

public abstract class NumberToken<T extends Number>
extends Token<T> {
    private static final byte MINUS;
    private StringBuilder sb = new StringBuilder();
    private byte[] currentByte = new byte[1];
    private ByteBuffer buf = ByteBuffer.wrap(this.currentByte);
    protected int multiplier = 1;
    private boolean done;
    private final byte terminator;

    NumberToken(ReadableByteChannel chan) {
        this(chan, BEncoder.E, 0);
    }

    NumberToken(ReadableByteChannel chan, byte terminator, byte firstByte) {
        super(chan);
        this.terminator = terminator;
        if (firstByte != 0) {
            if (firstByte < ZERO || firstByte > NINE) {
                throw new IllegalArgumentException("invalid first byte");
            }
            this.sb.append(firstByte - ZERO);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRead() throws IOException {
        if (this.done) {
            throw new IllegalStateException("this token is done.  Don't read it!");
        }
        while (true) {
            try {
                int read = this.chan.read(this.buf);
                if (read == -1) {
                    throw new EOFException("Could not read Integer Token");
                }
                if (read == 0) {
                    return;
                }
            }
            finally {
                this.buf.clear();
            }
            if (this.currentByte[0] < ZERO || this.currentByte[0] > NINE) {
                if (this.currentByte[0] == MINUS && this.sb.length() == 0 && this.multiplier != -1) {
                    this.multiplier = -1;
                    continue;
                }
                if (this.currentByte[0] == this.terminator && this.sb.length() != 0) {
                    try {
                        BigInteger b = new BigInteger(this.sb.toString());
                        this.result = this.getResult(b);
                    }
                    catch (NumberFormatException impossible) {
                        throw new IOException(impossible.getMessage());
                    }
                    this.sb = null;
                    this.done = true;
                    return;
                }
                throw new IOException("invalid integer");
            }
            if (this.currentByte[0] == ZERO) {
                switch (this.sb.length()) {
                    case 0: {
                        if (this.multiplier == -1) {
                            throw new IOException("negative 0");
                        }
                        this.multiplier = 0;
                        break;
                    }
                    case 1: {
                        if (this.multiplier != 0) break;
                        throw new IOException("leading 0s");
                    }
                }
                this.sb.append(0);
                continue;
            }
            if (this.multiplier == 0) {
                throw new IOException("leading 0s - wrong");
            }
            this.sb.append(this.currentByte[0] - ZERO);
        }
    }

    protected abstract T getResult(BigInteger var1) throws IOException;

    @Override
    protected boolean isDone() {
        return this.done;
    }

    static {
        byte minus = 0;
        try {
            minus = "-".getBytes("ISO-8859-1")[0];
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        MINUS = minus;
    }
}

