/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.download.listener;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.limegroup.bittorrent.BTTorrentFileDownloader;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.downloader.CoreDownloader;
import com.limegroup.gnutella.downloader.DownloadStateEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.limewire.bittorrent.TorrentManager;
import org.limewire.core.api.download.DownloadAction;
import org.limewire.core.api.download.DownloadException;
import org.limewire.core.api.download.DownloadItem;
import org.limewire.listener.EventListener;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.util.FileUtils;
import org.limewire.util.Objects;

public class TorrentDownloadListener
implements EventListener<DownloadStateEvent> {
    private static final Log LOG = LogFactory.getLog(TorrentDownloadListener.class);
    private final Downloader downloader;
    private final DownloadManager downloadManager;
    private final ActivityCallback activityCallback;
    private final List<DownloadItem> downloadItems;
    private final TorrentManager torrentManager;

    @Inject
    public TorrentDownloadListener(DownloadManager downloadManager, ActivityCallback activityCallback, TorrentManager torrentManager, @Assisted List<DownloadItem> downloadItems, @Assisted Downloader downloader) {
        this.downloader = Objects.nonNull(downloader, "downloader");
        this.downloadManager = Objects.nonNull(downloadManager, "downloadManager");
        this.torrentManager = Objects.nonNull(torrentManager, "torrentManager");
        this.activityCallback = Objects.nonNull(activityCallback, "activityCallback");
        this.downloadItems = Objects.nonNull(downloadItems, "downloadItems");
        if (downloader.getState() == Downloader.DownloadState.COMPLETE && downloader instanceof CoreDownloader) {
            this.handleEvent(new DownloadStateEvent((CoreDownloader)downloader, Downloader.DownloadState.COMPLETE));
        }
    }

    @Override
    public void handleEvent(DownloadStateEvent event) {
        Downloader.DownloadState downloadStatus = (Downloader.DownloadState)((Object)event.getType());
        if (Downloader.DownloadState.COMPLETE == downloadStatus) {
            if (this.downloader instanceof BTTorrentFileDownloader) {
                this.handleBTTorrentFileDownloader();
            } else {
                this.handleCoreDownloader();
            }
        }
    }

    private void handleCoreDownloader() {
        File possibleTorrentFile = null;
        possibleTorrentFile = this.downloader.getSaveFile();
        String fileExtension = FileUtils.getFileExtension(possibleTorrentFile);
        if ("torrent".equalsIgnoreCase(fileExtension)) {
            try {
                this.downloadManager.downloadTorrent(possibleTorrentFile, null, false);
                this.downloadItems.remove(this.getDownloadItem(this.downloader));
            }
            catch (DownloadException e) {
                final File torrentFile = possibleTorrentFile;
                this.activityCallback.handleDownloadException(new DownloadAction(){

                    @Override
                    public void download(File saveDirectory, boolean overwrite) throws DownloadException {
                        TorrentDownloadListener.this.downloadManager.downloadTorrent(torrentFile, saveDirectory, overwrite);
                        TorrentDownloadListener.this.downloadItems.remove(TorrentDownloadListener.this.getDownloadItem(TorrentDownloadListener.this.downloader));
                    }

                    @Override
                    public void downloadCanceled(DownloadException ignored) {
                    }
                }, e, false);
            }
        }
    }

    private void handleBTTorrentFileDownloader() {
        File torrentCopy = null;
        File torrentFile = null;
        BTTorrentFileDownloader btTorrentFileDownloader = (BTTorrentFileDownloader)this.downloader;
        try {
            torrentFile = btTorrentFileDownloader.getTorrentFile();
            try {
                torrentCopy = FileUtils.createTempFile("tmp-torrent", "");
                torrentCopy.deleteOnExit();
            }
            catch (IOException e) {
                LOG.error("Error copying the torrentFile", e);
            }
            FileUtils.copy(torrentFile, torrentCopy);
            this.downloadManager.downloadTorrent(torrentFile, null, false);
            this.downloadItems.remove(this.getDownloadItem(this.downloader));
        }
        catch (DownloadException e) {
            final File torrentFileFinal = torrentFile;
            final File torrentCopyFinal = torrentCopy;
            this.activityCallback.handleDownloadException(new DownloadAction(){

                @Override
                public void download(File saveDirectory, boolean overwrite) throws DownloadException {
                    FileUtils.copy(torrentCopyFinal, torrentFileFinal);
                    TorrentDownloadListener.this.downloadManager.downloadTorrent(torrentFileFinal, saveDirectory, overwrite);
                    TorrentDownloadListener.this.downloadItems.remove(TorrentDownloadListener.this.getDownloadItem(TorrentDownloadListener.this.downloader));
                    FileUtils.forceDelete(torrentCopyFinal);
                }

                @Override
                public void downloadCanceled(DownloadException ex) {
                    if (!TorrentDownloadListener.this.torrentManager.isDownloadingTorrent(torrentFileFinal)) {
                        FileUtils.forceDelete(torrentFileFinal);
                    }
                    FileUtils.forceDelete(torrentCopyFinal);
                }
            }, e, false);
        }
    }

    DownloadItem getDownloadItem(Downloader downloader) {
        DownloadItem item = (DownloadItem)downloader.getAttribute("limewire.download.glueItem");
        return item;
    }
}

