/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.mozilla;

import com.limegroup.gnutella.BandwidthTracker;
import com.limegroup.gnutella.InsufficientDataException;

class SimpleBandwidthTracker
implements BandwidthTracker {
    private static final int DEFAULT_INTERVAL = 500;
    private final int _interval;
    private long _lastAmount = 0L;
    private long _lastTimeMeasured = 0L;
    private long _firstTimeMeasured = 0L;
    private long _amount = 0L;
    private float _measuredBandwidth = -1.0f;

    public SimpleBandwidthTracker() {
        this(500);
    }

    public SimpleBandwidthTracker(int interval) {
        this._interval = interval;
    }

    public synchronized void count(long added) {
        if (added < 0L) {
            throw new IllegalArgumentException("Count values must be positive: " + added);
        }
        this.startCounting(-1L);
        this._amount += added;
    }

    private void startCounting(long now) {
        if (this._firstTimeMeasured == 0L) {
            if (now == -1L) {
                now = System.currentTimeMillis();
            }
            this._lastTimeMeasured = this._firstTimeMeasured = now;
        }
    }

    public synchronized long getTotalAmount() {
        return this._amount;
    }

    @Override
    public synchronized void measureBandwidth() {
        long now = System.currentTimeMillis();
        this.startCounting(now);
        if (now - this._lastTimeMeasured < (long)this._interval) {
            return;
        }
        this._measuredBandwidth = (this._amount - this._lastAmount) / (now - this._lastTimeMeasured);
        this._lastAmount = this._amount;
        this._lastTimeMeasured = now;
    }

    @Override
    public synchronized float getMeasuredBandwidth() throws InsufficientDataException {
        if (this._measuredBandwidth < 0.0f) {
            throw new InsufficientDataException();
        }
        return this._measuredBandwidth;
    }

    @Override
    public synchronized float getAverageBandwidth() {
        long time = System.currentTimeMillis() - this._firstTimeMeasured;
        return time <= 0L ? 0.0f : (float)(this._amount / time);
    }
}

