/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.search;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.limewire.core.api.URN;
import org.limewire.core.api.endpoint.RemoteHost;
import org.limewire.core.api.search.GroupedSearchResult;
import org.limewire.core.api.search.GroupedSearchResultListener;
import org.limewire.core.api.search.SearchResult;
import org.limewire.friend.api.Friend;
import org.limewire.util.Objects;

class GroupedSearchResultImpl
implements GroupedSearchResult {
    private static final Comparator<Friend> FRIEND_COMPARATOR = new FriendComparator();
    private static final Comparator<RemoteHost> REMOTE_HOST_COMPARATOR = new RemoteHostComparator();
    private final List<GroupedSearchResultListener> resultListeners = new CopyOnWriteArrayList<GroupedSearchResultListener>();
    private final Set<RemoteHost> remoteHosts = new CopyOnWriteArraySet<RemoteHost>();
    private volatile List<SearchResult> coreResults;
    private volatile Set<Friend> friends;
    private volatile boolean anonymous;
    private volatile float relevance = 0.0f;

    public GroupedSearchResultImpl(SearchResult searchResult, String query) {
        this.addNewSource(searchResult, query);
    }

    void addNewSource(SearchResult result, String query) {
        if (this.coreResults == null) {
            this.coreResults = Collections.singletonList(result);
        } else {
            if (this.coreResults.size() == 1) {
                this.coreResults = new CopyOnWriteArrayList<SearchResult>(this.coreResults);
            }
            this.coreResults.add(result);
        }
        this.relevance += result.getRelevance(query);
        for (RemoteHost host : result.getSources()) {
            this.remoteHosts.add(host);
            Friend friend = host.getFriendPresence().getFriend();
            if (friend.isAnonymous()) {
                this.anonymous = true;
                continue;
            }
            if (this.friends == null) {
                this.friends = Collections.singleton(friend);
                continue;
            }
            if (!(this.friends instanceof CopyOnWriteArraySet)) {
                CopyOnWriteArraySet<Friend> newFriends = new CopyOnWriteArraySet<Friend>();
                newFriends.addAll(this.friends);
                this.friends = newFriends;
            }
            this.friends.add(friend);
        }
    }

    void notifyNewSource() {
        for (GroupedSearchResultListener listener : this.resultListeners) {
            listener.sourceAdded();
        }
    }

    @Override
    public void addResultListener(GroupedSearchResultListener listener) {
        this.resultListeners.add(listener);
    }

    @Override
    public void removeResultListener(GroupedSearchResultListener listener) {
        this.resultListeners.remove(listener);
    }

    @Override
    public boolean isAnonymous() {
        return this.anonymous;
    }

    @Override
    public String getFileName() {
        return this.coreResults.get(0).getFileName();
    }

    @Override
    public Collection<Friend> getFriends() {
        if (this.friends == null) {
            return Collections.emptySet();
        }
        TreeSet<Friend> newFriends = new TreeSet<Friend>(FRIEND_COMPARATOR);
        newFriends.addAll(this.friends);
        return newFriends;
    }

    @Override
    public float getRelevance() {
        return this.relevance;
    }

    @Override
    public List<SearchResult> getSearchResults() {
        return this.coreResults;
    }

    @Override
    public Collection<RemoteHost> getSources() {
        TreeSet<RemoteHost> sources = new TreeSet<RemoteHost>(REMOTE_HOST_COMPARATOR);
        sources.addAll(this.remoteHosts);
        return sources;
    }

    @Override
    public URN getUrn() {
        return this.coreResults.get(0).getUrn();
    }

    private static class RemoteHostComparator
    implements Comparator<RemoteHost> {
        private RemoteHostComparator() {
        }

        @Override
        public int compare(RemoteHost o1, RemoteHost o2) {
            boolean anonymous2;
            int compare = 0;
            boolean anonymous1 = o1.getFriendPresence().getFriend().isAnonymous();
            if (anonymous1 == (anonymous2 = o2.getFriendPresence().getFriend().isAnonymous())) {
                String name1 = o1.getFriendPresence().getFriend().getRenderName();
                String name2 = o2.getFriendPresence().getFriend().getRenderName();
                compare = name1.compareToIgnoreCase(name2);
            } else if (anonymous1) {
                compare = 1;
            } else if (anonymous2) {
                compare = -1;
            }
            return compare;
        }
    }

    private static class FriendComparator
    implements Comparator<Friend> {
        private FriendComparator() {
        }

        @Override
        public int compare(Friend o1, Friend o2) {
            String id1 = o1.getId();
            String id2 = o2.getId();
            return Objects.compareToNullIgnoreCase(id1, id2, false);
        }
    }
}

