/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.util;

import com.limegroup.gnutella.xml.LimeXMLDocument;
import org.limewire.core.api.Category;
import org.limewire.core.api.FilePropertyKey;
import org.limewire.util.CommonUtils;
import org.limewire.util.I18NConvert;

public class FilePropertyKeyPopulator {
    public static int calculateQuality(Category category, String extension, long fileSize, LimeXMLDocument document) {
        Long bitrate = null;
        Long length = null;
        Long height = null;
        Long width = null;
        switch (category) {
            case AUDIO: {
                if (document != null) {
                    bitrate = CommonUtils.parseLongNoException(document.getValue("audios__audio__bitrate__"));
                    length = CommonUtils.parseLongNoException(document.getValue("audios__audio__seconds__"));
                }
                return FilePropertyKeyPopulator.toAudioQualityScore(extension, fileSize, bitrate, length);
            }
            case VIDEO: {
                if (document != null) {
                    bitrate = CommonUtils.parseLongNoException(document.getValue("videos__video__bitrate__"));
                    length = CommonUtils.parseLongNoException(document.getValue("videos__video__length__"));
                    height = CommonUtils.parseLongNoException(document.getValue("videos__video__height__"));
                    width = CommonUtils.parseLongNoException(document.getValue("videos__video__width__"));
                }
                return FilePropertyKeyPopulator.toVideoQualityScore(extension, fileSize, bitrate, length, height, width);
            }
        }
        return -1;
    }

    public static Object get(Category category, FilePropertyKey property, LimeXMLDocument document) {
        String limeXmlName;
        if (document != null && (limeXmlName = FilePropertyKeyPopulator.getLimeXmlName(category, property)) != null) {
            Object value = document.getValue(limeXmlName);
            if ((value = FilePropertyKeyPopulator.sanitizeValue(property, value)) != null) {
                return value;
            }
        }
        return null;
    }

    public static Object sanitizeValue(FilePropertyKey property, Object value) {
        if (value != null && !value.toString().isEmpty()) {
            if (value instanceof String) {
                if (FilePropertyKey.isLong(property)) {
                    return CommonUtils.parseLongNoException((String)value);
                }
                return I18NConvert.instance().compose((String)value).intern();
            }
            return value;
        }
        return null;
    }

    private static int toAudioQualityScore(String fileExtension, long fileSize, Long bitrate, Long length) {
        int quality = -1;
        if ("wav".equalsIgnoreCase(fileExtension) || "flac".equalsIgnoreCase(fileExtension)) {
            quality = 3;
        } else if (bitrate != null) {
            if ("mp3".equalsIgnoreCase(fileExtension)) {
                quality = bitrate < 96L ? 1 : (bitrate < 192L ? 2 : 3);
            } else if ("wma".equalsIgnoreCase(fileExtension)) {
                quality = bitrate < 64L ? 1 : (bitrate < 128L ? 2 : 3);
            } else if ("aac".equalsIgnoreCase(fileExtension) || "m4a".equalsIgnoreCase(fileExtension) || "m4b".equalsIgnoreCase(fileExtension) || "m4p".equalsIgnoreCase(fileExtension) || "m4v".equalsIgnoreCase(fileExtension) || "mp4".equalsIgnoreCase(fileExtension)) {
                quality = bitrate < 64L ? 1 : (bitrate < 128L ? 2 : 3);
            } else if ("ogg".equalsIgnoreCase(fileExtension) || "ogv".equalsIgnoreCase(fileExtension) || "oga".equalsIgnoreCase(fileExtension) || "ogx".equalsIgnoreCase(fileExtension)) {
                quality = bitrate < 48L ? 1 : (bitrate < 96L ? 2 : 3);
            }
        } else {
            quality = length != null && length < 30L ? 1 : (fileSize < 0x100000L ? 1 : (fileSize < 0x300000L ? 2 : 3));
        }
        return quality;
    }

    private static int toVideoQualityScore(String fileExtension, long fileSize, Long bitrate, Long length, Long height, Long width) {
        int quality = -1;
        quality = "mpg".equalsIgnoreCase(fileExtension) && height != null && width != null ? (height * width < 84480L ? 1 : (height * width < 168960L ? 2 : 3)) : (length != null && length < 60L ? 1 : (fileSize < 0x500000L ? 1 : (fileSize < 0x6400000L ? 2 : 3)));
        return quality;
    }

    public static String getLimeXmlSchemaUri(Category category) {
        switch (category) {
            case AUDIO: {
                return "http://www.limewire.com/schemas/audio.xsd";
            }
            case DOCUMENT: {
                return "http://www.limewire.com/schemas/document.xsd";
            }
            case IMAGE: {
                return "http://www.limewire.com/schemas/image.xsd";
            }
            case PROGRAM: {
                return "http://www.limewire.com/schemas/application.xsd";
            }
            case VIDEO: {
                return "http://www.limewire.com/schemas/video.xsd";
            }
        }
        throw new UnsupportedOperationException("Category: " + (Object)((Object)category) + " is not supported.");
    }

    public static String getLimeXmlName(Category category, FilePropertyKey filePropertyKey) {
        switch (category) {
            case AUDIO: {
                switch (filePropertyKey) {
                    case ALBUM: {
                        return "audios__audio__album__";
                    }
                    case AUTHOR: {
                        return "audios__audio__artist__";
                    }
                    case BITRATE: {
                        return "audios__audio__bitrate__";
                    }
                    case DESCRIPTION: {
                        return "audios__audio__comments__";
                    }
                    case GENRE: {
                        return "audios__audio__genre__";
                    }
                    case LENGTH: {
                        return "audios__audio__seconds__";
                    }
                    case TRACK_NUMBER: {
                        return "audios__audio__track__";
                    }
                    case YEAR: {
                        return "audios__audio__year__";
                    }
                    case TITLE: {
                        return "audios__audio__title__";
                    }
                }
                break;
            }
            case DOCUMENT: {
                switch (filePropertyKey) {
                    case AUTHOR: {
                        return "documents__document__author__";
                    }
                    case TITLE: {
                        return "documents__document__title__";
                    }
                    case DESCRIPTION: {
                        return "documents__document__topic__";
                    }
                }
                break;
            }
            case IMAGE: {
                switch (filePropertyKey) {
                    case AUTHOR: {
                        return "images__image__artist__";
                    }
                    case TITLE: {
                        return "images__image__title__";
                    }
                    case DESCRIPTION: {
                        return "images__image__description__";
                    }
                }
                break;
            }
            case PROGRAM: {
                switch (filePropertyKey) {
                    case COMPANY: {
                        return "applications__application__publisher__";
                    }
                    case PLATFORM: {
                        return "applications__application__platform__";
                    }
                    case TITLE: {
                        return "applications__application__name__";
                    }
                }
                break;
            }
            case VIDEO: {
                switch (filePropertyKey) {
                    case AUTHOR: {
                        return "videos__video__producer__";
                    }
                    case BITRATE: {
                        return "videos__video__bitrate__";
                    }
                    case DESCRIPTION: {
                        return "videos__video__comments__";
                    }
                    case COMPANY: {
                        return "videos__video__studio__";
                    }
                    case GENRE: {
                        return "videos__video__type__";
                    }
                    case HEIGHT: {
                        return "videos__video__height__";
                    }
                    case WIDTH: {
                        return "videos__video__width__";
                    }
                    case LENGTH: {
                        return "videos__video__length__";
                    }
                    case YEAR: {
                        return "videos__video__year__";
                    }
                    case TITLE: {
                        return "videos__video__title__";
                    }
                    case RATING: {
                        return "videos__video__rating__";
                    }
                }
            }
        }
        return null;
    }
}

