/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.settings;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import java.util.Map;
import java.util.Properties;
import org.limewire.concurrent.AbstractLazySingletonProvider;
import org.limewire.core.api.malware.VirusUpdatesURL;
import org.limewire.core.settings.DownloadSettings;
import org.limewire.core.settings.GeocodeSettings;
import org.limewire.core.settings.InspectionsSettings;
import org.limewire.geocode.GeoLocation;
import org.limewire.geocode.GeocodeUrl;
import org.limewire.inject.AbstractModule;
import org.limewire.inject.MutableProvider;
import org.limewire.inspection.InspectionsServerUrls;
import org.limewire.setting.StringSetting;

public class LimeWireCoreSettingsModule
extends AbstractModule {
    @Override
    protected void configure() {
        this.bind(String.class).annotatedWith(GeocodeUrl.class).toProvider(GeocodeSettings.GEOCODE_URL);
        this.bind(new TypeLiteral<MutableProvider<Properties>>(){}).annotatedWith(GeoLocation.class).toInstance(GeocodeSettings.GEO_LOCATION);
        this.bind(new TypeLiteral<Map<String, StringSetting>>(){}).annotatedWith(InspectionsServerUrls.class).toProvider(InspectionsURLsMapProvider.class);
        this.bind(new TypeLiteral<String>(){}).annotatedWith(VirusUpdatesURL.class).toProvider(DownloadSettings.VIRUS_UPDATES_SERVER);
    }

    @Singleton
    private static class InspectionsURLsMapProvider
    extends AbstractLazySingletonProvider<Map<String, StringSetting>> {
        private InspectionsURLsMapProvider() {
        }

        @Override
        protected Map<String, StringSetting> createObject() {
            return ImmutableMap.of("INSPECTION_SPEC_REQUEST_URL", InspectionsSettings.INSPECTION_SPEC_REQUEST_URL, "INSPECTION_SPEC_SUBMIT_URL", InspectionsSettings.INSPECTION_SPEC_SUBMIT_URL);
        }
    }
}

