/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.friend.impl;

import com.google.inject.Inject;
import java.util.Collection;
import org.limewire.friend.api.Friend;
import org.limewire.friend.api.FriendPresence;
import org.limewire.friend.api.FriendPresenceEvent;
import org.limewire.friend.api.MutableFriendManager;
import org.limewire.friend.api.PresenceEvent;
import org.limewire.friend.api.RosterEvent;
import org.limewire.inject.EagerSingleton;
import org.limewire.listener.EventBroadcaster;
import org.limewire.listener.EventListener;
import org.limewire.listener.ListenerSupport;

@EagerSingleton
class FriendListListeners {
    private final PresenceListener presenceListener = new PresenceListener();
    private final MutableFriendManager friendManager;
    private final EventBroadcaster<FriendPresenceEvent> friendPresenceBroadcaster;

    @Inject
    FriendListListeners(MutableFriendManager friendManager, EventBroadcaster<FriendPresenceEvent> friendPresenceBroadcaster) {
        this.friendManager = friendManager;
        this.friendPresenceBroadcaster = friendPresenceBroadcaster;
    }

    @Inject
    void register(ListenerSupport<RosterEvent> rosterListeners) {
        rosterListeners.addListener(new EventListener<RosterEvent>(){

            @Override
            public void handleEvent(RosterEvent event) {
                Collection friends = (Collection)event.getData();
                switch ((RosterEvent.Type)((Object)event.getType())) {
                    case FRIENDS_ADDED: {
                        FriendListListeners.this.addKnownFriends(friends);
                        break;
                    }
                    case FRIENDS_UPDATED: {
                        FriendListListeners.this.updateFriends(friends);
                        break;
                    }
                    case FRIENDS_DELETED: {
                        FriendListListeners.this.removeKnownFriends(friends);
                    }
                }
            }
        });
    }

    private void addKnownFriends(Collection<Friend> friends) {
        for (Friend friend : friends) {
            this.addKnownFriend(friend);
        }
    }

    private void addKnownFriend(Friend friend) {
        if (friend.isSubscribed()) {
            friend.addPresenceListener(this.presenceListener);
            this.friendManager.addKnownFriend(friend);
        }
    }

    private void updateFriends(Collection<Friend> friends) {
        for (Friend friend : friends) {
            if (friend.isSubscribed()) {
                this.addKnownFriend(friend);
                continue;
            }
            this.friendManager.removeKnownFriend(friend, true);
        }
    }

    private void removeKnownFriends(Collection<Friend> friends) {
        for (Friend friend : friends) {
            this.friendManager.removeKnownFriend(friend, true);
        }
    }

    private void updatePresence(FriendPresence presence) {
        this.friendPresenceBroadcaster.broadcast(new FriendPresenceEvent(presence, FriendPresenceEvent.Type.UPDATE));
    }

    private void addPresence(FriendPresence presence) {
        Friend friend = presence.getFriend();
        if (friend.getPresences().size() == 1) {
            this.friendManager.addAvailableFriend(friend);
        }
        this.friendPresenceBroadcaster.broadcast(new FriendPresenceEvent(presence, FriendPresenceEvent.Type.ADDED));
    }

    private void removePresence(FriendPresence presence) {
        Friend friend = presence.getFriend();
        if (!friend.isSignedIn()) {
            this.friendManager.removeAvailableFriend(friend);
        }
        this.friendPresenceBroadcaster.broadcast(new FriendPresenceEvent(presence, FriendPresenceEvent.Type.REMOVED));
    }

    private class PresenceListener
    implements EventListener<PresenceEvent> {
        private PresenceListener() {
        }

        @Override
        public void handleEvent(PresenceEvent event) {
            switch (((FriendPresence)event.getData()).getType()) {
                case available: {
                    switch ((PresenceEvent.Type)((Object)event.getType())) {
                        case PRESENCE_NEW: {
                            FriendListListeners.this.addPresence((FriendPresence)event.getData());
                            break;
                        }
                        case PRESENCE_UPDATE: {
                            FriendListListeners.this.updatePresence((FriendPresence)event.getData());
                        }
                    }
                    break;
                }
                case unavailable: {
                    FriendListListeners.this.removePresence((FriendPresence)event.getData());
                }
            }
        }
    }
}

