/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.friend.impl;

import com.google.inject.Inject;
import java.util.concurrent.atomic.AtomicLong;
import org.limewire.friend.api.FriendConnectionEvent;
import org.limewire.inject.EagerSingleton;
import org.limewire.inspection.DataCategory;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectableContainer;
import org.limewire.inspection.InspectionPoint;
import org.limewire.listener.EventListener;
import org.limewire.listener.ListenerSupport;

@EagerSingleton
public class SessionTimeListener
implements EventListener<FriendConnectionEvent> {
    private long connectedTime;
    private final AtomicLong previousSessionTimes = new AtomicLong();

    @Inject
    void register(ListenerSupport<FriendConnectionEvent> listenerSupport) {
        listenerSupport.addListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleEvent(FriendConnectionEvent event) {
        AtomicLong atomicLong = this.previousSessionTimes;
        synchronized (atomicLong) {
            switch ((FriendConnectionEvent.Type)((Object)event.getType())) {
                case CONNECTED: {
                    this.connectedTime = System.currentTimeMillis();
                    break;
                }
                case DISCONNECTED: {
                    this.previousSessionTimes.addAndGet(System.currentTimeMillis() - this.connectedTime);
                    this.connectedTime = 0L;
                }
            }
        }
    }

    private class SessionTimeInspectable
    implements Inspectable {
        private SessionTimeInspectable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object inspect() {
            AtomicLong atomicLong = SessionTimeListener.this.previousSessionTimes;
            synchronized (atomicLong) {
                return SessionTimeListener.this.connectedTime == 0L ? SessionTimeListener.this.previousSessionTimes.get() : SessionTimeListener.this.previousSessionTimes.get() + (System.currentTimeMillis() - SessionTimeListener.this.connectedTime);
            }
        }
    }

    @InspectableContainer
    private class LazyInspectableContainer {
        @InspectionPoint(value="friends session time", category=DataCategory.USAGE)
        private Inspectable sessionTime;

        private LazyInspectableContainer() {
            this.sessionTime = new SessionTimeInspectable();
        }
    }
}

