/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito;

import java.io.Serializable;
import java.util.Map;
import org.limewire.mojito.util.FixedSizeHashMap;

public class StatusCode
implements Serializable,
Comparable<StatusCode> {
    private static final long serialVersionUID = 948952689527998250L;
    private static final Map<Integer, StatusCode> CODES = new FixedSizeHashMap<Integer, StatusCode>(16, 0.75f, true, 32);
    private final int code;
    private final String description;

    private StatusCode(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public int shortValue() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public int compareTo(StatusCode other) {
        return this.code - other.code;
    }

    public int hashCode() {
        return this.code;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StatusCode)) {
            return false;
        }
        return this.compareTo((StatusCode)o) == 0;
    }

    public String toString() {
        return this.code + ": " + this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StatusCode valueOf(int code, String description) {
        if (description == null) {
            throw new NullPointerException("description must not be null, code: " + code);
        }
        Integer key = code & 0xFFFF;
        StatusCode statusCode = null;
        Map<Integer, StatusCode> map = CODES;
        synchronized (map) {
            statusCode = CODES.get(key);
            if (statusCode == null || !statusCode.description.equals(description)) {
                statusCode = new StatusCode(code, description);
                CODES.put(key, statusCode);
            }
        }
        return statusCode;
    }
}

