/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.handler.request;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.mojito.Context;
import org.limewire.mojito.handler.request.AbstractRequestHandler;
import org.limewire.mojito.messages.PingRequest;
import org.limewire.mojito.messages.PingResponse;
import org.limewire.mojito.messages.RequestMessage;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.statistics.NetworkStatisticContainer;
import org.limewire.mojito.util.MessageUtils;

public class PingRequestHandler
extends AbstractRequestHandler {
    private static final Log LOG = LogFactory.getLog(PingRequestHandler.class);
    private final NetworkStatisticContainer networkStats;

    public PingRequestHandler(Context context) {
        super(context);
        this.networkStats = context.getNetworkStats();
    }

    @Override
    public void request(RequestMessage message) throws IOException {
        this.networkStats.PING_REQUESTS.incrementStat();
        PingRequest request = (PingRequest)message;
        Contact node = request.getContact();
        if (this.context.isBootstrapping() && !MessageUtils.isCollisionPingRequest(this.context.getLocalNodeID(), message)) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Received a PingRequest from " + node + " but local Node is bootstrapping");
            }
            return;
        }
        PingResponse response = this.context.getMessageHelper().createPingResponse(request, node.getContactAddress());
        this.context.getMessageDispatcher().send(node, response);
        this.networkStats.PONGS_SENT.incrementStat();
    }
}

