/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.routing.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.NetworkUtils;
import org.limewire.mojito.KUID;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.Vendor;
import org.limewire.mojito.routing.Version;
import org.limewire.mojito.util.ContactUtils;

public class LocalContact
implements Contact {
    private static final Log LOG = LogFactory.getLog(LocalContact.class);
    private static final long serialVersionUID = -1372388406248015059L;
    private volatile Vendor vendor;
    private volatile Version version;
    private volatile KUID nodeId;
    private volatile int instanceId;
    private volatile int flags;
    private volatile transient SocketAddress sourceAddress;
    private volatile transient SocketAddress contactAddress;
    private transient SocketAddress tmpExternalAddress;

    public LocalContact(Vendor vendor, Version version, KUID nodeId, int instanceId, boolean firewalled) {
        this(vendor, version, nodeId, instanceId, firewalled ? 1 : 0);
    }

    public LocalContact(Vendor vendor, Version version, KUID nodeId, int instanceId, int flags) {
        this.vendor = vendor;
        this.version = version;
        this.nodeId = nodeId;
        this.instanceId = instanceId;
        this.flags = flags;
        this.init();
    }

    private void init() {
        this.contactAddress = new InetSocketAddress("localhost", 0);
    }

    public void setVendor(Vendor vendor) {
        this.vendor = vendor;
    }

    @Override
    public Vendor getVendor() {
        return this.vendor;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    public void setNodeID(KUID nodeId) {
        this.nodeId = nodeId;
    }

    @Override
    public KUID getNodeID() {
        return this.nodeId;
    }

    @Override
    public int getInstanceID() {
        return this.instanceId;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    public void nextInstanceID() {
        this.instanceId = (this.instanceId + 1) % 255;
    }

    @Override
    public SocketAddress getContactAddress() {
        return this.contactAddress;
    }

    public synchronized void setContactAddress(SocketAddress contactAddress) {
        this.contactAddress = contactAddress;
        this.tmpExternalAddress = null;
    }

    public synchronized void setExternalPort(int port) {
        InetSocketAddress addr = (InetSocketAddress)this.getContactAddress();
        this.setContactAddress(new InetSocketAddress(addr.getAddress(), port));
    }

    public int getExternalPort() {
        return ((InetSocketAddress)this.getContactAddress()).getPort();
    }

    @Override
    public SocketAddress getSourceAddress() {
        return this.sourceAddress;
    }

    public synchronized void setSourceAddress(SocketAddress sourceAddress) {
        this.sourceAddress = sourceAddress;
    }

    @Override
    public boolean isFirewalled() {
        return (this.flags & 1) != 0;
    }

    public void setFirewalled(boolean firewalled) {
        if (this.isFirewalled() != firewalled) {
            this.flags ^= 1;
        }
    }

    public synchronized boolean setExternalAddress(SocketAddress externalSocketAddress) {
        if (externalSocketAddress == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("SocketAddress is null");
            }
            return false;
        }
        InetAddress externalAddress = ((InetSocketAddress)externalSocketAddress).getAddress();
        InetAddress currentAddress = ((InetSocketAddress)this.getContactAddress()).getAddress();
        int currentPort = ((InetSocketAddress)this.getContactAddress()).getPort();
        if (externalAddress.equals(currentAddress)) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Reported external address is equal to current external address: " + externalAddress);
            }
            return false;
        }
        if (ContactUtils.isPrivateAddress(externalAddress)) {
            if (LOG.isInfoEnabled()) {
                LOG.info(externalAddress + " is a PRIVATE address");
            }
            return false;
        }
        if (!NetworkUtils.isSameAddressSpace(externalAddress, currentAddress)) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("The current external address " + currentAddress + " is from a different IP address space than " + externalAddress);
            }
            return false;
        }
        InetSocketAddress addr = new InetSocketAddress(externalAddress, currentPort);
        if (this.tmpExternalAddress == null || this.tmpExternalAddress.equals(addr)) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Setting the current external address from " + this.contactAddress + " to " + addr);
            }
            this.contactAddress = addr;
        }
        this.tmpExternalAddress = addr;
        return true;
    }

    @Override
    public int getFailures() {
        return 0;
    }

    @Override
    public long getLastFailedTime() {
        return 0L;
    }

    @Override
    public void setRoundTripTime(long rtt) {
    }

    @Override
    public long getRoundTripTime() {
        return 0L;
    }

    @Override
    public void setTimeStamp(long timeStamp) {
    }

    @Override
    public long getTimeStamp() {
        return Long.MAX_VALUE;
    }

    @Override
    public long getAdaptativeTimeout() {
        return 0L;
    }

    @Override
    public void handleFailure() {
    }

    @Override
    public boolean hasBeenRecentlyAlive() {
        return true;
    }

    @Override
    public boolean hasFailed() {
        return false;
    }

    @Override
    public boolean isAlive() {
        return false;
    }

    @Override
    public boolean isDead() {
        return false;
    }

    @Override
    public boolean isUnknown() {
        return true;
    }

    @Override
    public void unknown() {
    }

    @Override
    public boolean isShutdown() {
        return (this.flags & 2) != 0;
    }

    @Override
    public void shutdown(boolean shutdown) {
        if (this.isShutdown() != shutdown) {
            this.flags ^= 2;
        }
    }

    @Override
    public void updateWithExistingContact(Contact existing) {
        if (existing != this) {
            throw new UnsupportedOperationException();
        }
    }

    public int hashCode() {
        return this.nodeId.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocalContact)) {
            return false;
        }
        return this.nodeId.equals(((Contact)o).getNodeID());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(ContactUtils.toString(this.getNodeID(), this.getContactAddress())).append(", instanceId=").append(this.getInstanceID()).append(", firewalled=").append(this.isFirewalled());
        return buffer.toString();
    }
}

