/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.net;

import org.limewire.io.Connectable;
import org.limewire.io.GUID;
import org.limewire.io.NetworkUtils;
import org.limewire.util.Objects;
import org.limewire.util.StringUtils;

public class ConnectBackRequest {
    private final Connectable address;
    private final GUID clientGuid;
    private final int supportedFWTVersion;
    private int hashCode = -1;

    public ConnectBackRequest(Connectable address, GUID clientGuid, int supportedFWTVersion) {
        this.address = Objects.nonNull(address, "address");
        this.clientGuid = Objects.nonNull(clientGuid, "clientGuid");
        this.supportedFWTVersion = supportedFWTVersion;
        if (!NetworkUtils.isValidIpPort(address)) {
            throw new IllegalArgumentException("invalid address: " + address);
        }
    }

    public Connectable getAddress() {
        return this.address;
    }

    public GUID getClientGuid() {
        return this.clientGuid;
    }

    public int getSupportedFWTVersion() {
        return this.supportedFWTVersion;
    }

    public String toString() {
        return StringUtils.toString(this, new Object[0]);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConnectBackRequest) {
            ConnectBackRequest other = (ConnectBackRequest)obj;
            return this.address.equals(other.address) && this.clientGuid.equals(other.clientGuid) && this.supportedFWTVersion == other.supportedFWTVersion;
        }
        return false;
    }

    public int hashCode() {
        int hash = this.hashCode;
        if (hash == -1) {
            hash = this.address.hashCode();
            hash = hash * 31 + this.clientGuid.hashCode();
            this.hashCode = hash = hash * 31 + this.supportedFWTVersion;
        }
        return hash;
    }
}

