/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio;

import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.limewire.nio.NIODispatcher;
import org.limewire.nio.Throttle;
import org.limewire.nio.ThrottleListener;
import org.limewire.nio.observer.IOErrorObserver;

public class NBThrottle
implements Throttle {
    private static final int DEFAULT_TICK_TIME = 100;
    private final int MILLIS_PER_TICK;
    private final int MAXIMUM_TO_GIVE;
    private final int MINIMUM_TO_GIVE;
    private final boolean _write;
    private final int _processOp;
    private volatile int _bytesPerTick;
    private volatile int _available;
    private long _nextTickTime = -1L;
    private Set<ThrottleListener> _requests = new HashSet<ThrottleListener>();
    private Map<Object, ThrottleListener> _interested = new LinkedHashMap<Object, ThrottleListener>();
    private Map<Object, SelectionKey> _ready = new HashMap<Object, SelectionKey>();
    private boolean _active = false;

    public NBThrottle(boolean forWriting, float bytesPerSecond) {
        this(forWriting, bytesPerSecond, true, 100);
    }

    public NBThrottle(boolean forWriting, float bytesPerSecond, int maxRequestors, int maxLatency) {
        this(forWriting, bytesPerSecond, true, maxRequestors == 0 ? 100 : maxLatency / maxRequestors);
    }

    protected NBThrottle(boolean forWriting, float bytesPerSecond, boolean addToDispatcher, int millisPerTick) {
        this.MILLIS_PER_TICK = Math.min(100, Math.max(50, millisPerTick));
        int ticksPerSecond = 1000 / this.MILLIS_PER_TICK;
        this._write = forWriting;
        this._processOp = forWriting ? 4 : 1;
        this._bytesPerTick = (int)(bytesPerSecond / (float)ticksPerSecond);
        if (addToDispatcher) {
            NIODispatcher.instance().addThrottle(this);
        }
        if (forWriting) {
            this.MAXIMUM_TO_GIVE = 1400;
            this.MINIMUM_TO_GIVE = 30;
        } else {
            this.MAXIMUM_TO_GIVE = Integer.MAX_VALUE;
            this.MINIMUM_TO_GIVE = 1;
        }
    }

    @Override
    public void setRate(float bytesPerSecond) {
        int ticksPerSecond = 1000 / this.MILLIS_PER_TICK;
        this._bytesPerTick = (int)(bytesPerSecond / (float)ticksPerSecond);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void selectableKeys(Collection<? extends SelectionKey> keys) {
        if (this._available >= this.MINIMUM_TO_GIVE && !this._interested.isEmpty()) {
            Iterator<? extends SelectionKey> i = keys.iterator();
            while (i.hasNext()) {
                SelectionKey key = i.next();
                try {
                    IOErrorObserver attachment;
                    if (!key.isValid() || !(this._write ? key.isWritable() : key.isReadable()) || !this._interested.containsKey(attachment = NIODispatcher.instance().attachment(key.attachment()))) continue;
                    this._ready.put(attachment, key);
                }
                catch (CancelledKeyException ignored) {
                    i.remove();
                }
            }
            this._active = true;
            long now = System.currentTimeMillis();
            Iterator<Map.Entry<Object, ThrottleListener>> i2 = this._interested.entrySet().iterator();
            while (i2.hasNext()) {
                Map.Entry<Object, ThrottleListener> next = i2.next();
                ThrottleListener listener = next.getValue();
                Object attachment = next.getKey();
                SelectionKey key = this._ready.remove(attachment);
                if (!listener.isOpen()) {
                    i2.remove();
                    continue;
                }
                if (key == null) continue;
                i2.remove();
                listener.requestBandwidth();
                try {
                    NIODispatcher.instance().process(now, key, key.attachment(), this._processOp);
                }
                finally {
                    listener.releaseBandwidth();
                }
                if (this._available >= this.MINIMUM_TO_GIVE) continue;
                break;
            }
            this._active = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void interest(ThrottleListener writer) {
        boolean wakeup;
        Set<ThrottleListener> set = this._requests;
        synchronized (set) {
            wakeup = this._requests.isEmpty();
            this._requests.add(writer);
        }
        if (wakeup || this._available >= this.MINIMUM_TO_GIVE) {
            NIODispatcher.instance().wakeup();
        }
    }

    @Override
    public int request() {
        if (!this._active) {
            return 0;
        }
        int ret = Math.min(this._available, this.MAXIMUM_TO_GIVE);
        this._available -= ret;
        return ret;
    }

    @Override
    public void release(int amount) {
        if (this._active) {
            this._available += amount;
        }
    }

    void tick(long currentTime) {
        if (currentTime >= this._nextTickTime) {
            this._available = this._bytesPerTick;
            this._nextTickTime = currentTime + (long)this.MILLIS_PER_TICK;
            this.spreadBandwidth();
        } else if (this._available >= this.MINIMUM_TO_GIVE) {
            this.spreadBandwidth();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long nextTickTime() {
        Set<ThrottleListener> set = this._requests;
        synchronized (set) {
            if (this._requests.isEmpty() && this._interested.isEmpty()) {
                return Long.MAX_VALUE;
            }
        }
        return this._nextTickTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spreadBandwidth() {
        Set<ThrottleListener> set = this._requests;
        synchronized (set) {
            if (!this._requests.isEmpty()) {
                for (ThrottleListener req : this._requests) {
                    Object attachment = req.getAttachment();
                    if (attachment == null) {
                        throw new IllegalStateException("must have an attachment - listener: " + req);
                    }
                    if (!req.bandwidthAvailable()) continue;
                    this._interested.put(attachment, req);
                }
                this._requests.clear();
            }
        }
    }
}

