/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio.ssl;

import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.nio.ByteBufferCache;
import org.limewire.util.BufferUtils;

public class SSLEngineTest {
    private static final Log LOG = LogFactory.getLog(SSLEngineTest.class);
    private final SSLContext context;
    private final String[] cipherSuites;
    private final ByteBufferCache cache;
    private Throwable lastFailureCause;

    public SSLEngineTest(SSLContext context, String[] cipherSuites, ByteBufferCache cache) {
        this.context = context;
        this.cipherSuites = cipherSuites;
        this.cache = cache;
    }

    public boolean go() {
        try {
            this.goImpl();
            return true;
        }
        catch (Throwable t) {
            LOG.error("Error in TLS!", t);
            this.lastFailureCause = t;
            return false;
        }
    }

    public Throwable getLastFailureCause() {
        return this.lastFailureCause;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void goImpl() throws SSLException {
        SSLEngine server = this.context.createSSLEngine();
        SSLEngine client = this.context.createSSLEngine();
        server.setEnabledCipherSuites(this.cipherSuites);
        client.setEnabledCipherSuites(this.cipherSuites);
        server.setUseClientMode(false);
        client.setUseClientMode(true);
        server.setNeedClientAuth(false);
        server.setWantClientAuth(false);
        SSLSession session = server.getSession();
        ByteBuffer clientOut = this.cache.getHeap(session.getPacketBufferSize());
        ByteBuffer serverOut = this.cache.getHeap(session.getPacketBufferSize());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting handshake loop.\nServer: " + server + "\nClient: " + client);
        }
        try {
            this.doHandshake(client, server, clientOut, serverOut);
            this.doData(client, server, clientOut, serverOut);
        }
        finally {
            this.cache.release(clientOut);
            this.cache.release(serverOut);
        }
    }

    private void doHandshake(SSLEngine client, SSLEngine server, ByteBuffer clientOut, ByteBuffer serverOut) throws SSLException {
        SSLEngineResult.HandshakeStatus sh;
        SSLEngineResult.HandshakeStatus ch;
        SSLEngineResult clientResult = new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_WRAP, 0, 0);
        SSLEngineResult serverResult = new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_UNWRAP, 0, 0);
        do {
            LOG.debug("Processing client handshake loop");
            serverOut.flip();
            clientResult = this.handshakeLoop(clientResult, client, serverOut, clientOut);
            serverOut.compact();
            LOG.debug("Processing server handshake loop");
            clientOut.flip();
            serverResult = this.handshakeLoop(serverResult, server, clientOut, serverOut);
            clientOut.compact();
            ch = clientResult.getHandshakeStatus();
            sh = serverResult.getHandshakeStatus();
        } while (ch != SSLEngineResult.HandshakeStatus.FINISHED && ch != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING || sh != SSLEngineResult.HandshakeStatus.FINISHED && sh != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING);
    }

    private SSLEngineResult handshakeLoop(SSLEngineResult result, SSLEngine engine, ByteBuffer src, ByteBuffer dst) throws SSLException {
        while (true) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing result: " + result + ", from engine: " + engine + ", src: " + src + ", dst: " + dst);
            }
            if (result.getStatus() != SSLEngineResult.Status.OK) {
                throw new IllegalStateException("Invalid result status: " + result);
            }
            switch (result.getHandshakeStatus()) {
                case FINISHED: 
                case NOT_HANDSHAKING: {
                    return result;
                }
                case NEED_UNWRAP: {
                    if (!src.hasRemaining()) {
                        return result;
                    }
                    result = engine.unwrap(src, dst);
                    break;
                }
                case NEED_TASK: {
                    Runnable runner = engine.getDelegatedTask();
                    runner.run();
                    result = new SSLEngineResult(SSLEngineResult.Status.OK, engine.getHandshakeStatus(), 0, 0);
                    break;
                }
                case NEED_WRAP: {
                    if (dst.position() != 0) {
                        return result;
                    }
                    result = engine.wrap(BufferUtils.getEmptyBuffer(), dst);
                }
            }
        }
    }

    private void doData(SSLEngine client, SSLEngine server, ByteBuffer clientOut, ByteBuffer serverOut) throws SSLException {
        LOG.debug("Doing client -> server data test");
        this.doDataTest(new byte[]{67, 76, 73, 69, 78, 84, 32, 84, 69, 83, 84, 32, 79, 85, 84}, client, server, clientOut, serverOut);
        LOG.debug("Doing server -> client data test");
        this.doDataTest(new byte[]{83, 69, 82, 86, 69, 82, 32, 84, 69, 83, 84, 32, 79, 85, 84}, server, client, serverOut, clientOut);
        LOG.debug("Finished data test");
    }

    private void doDataTest(byte[] testData, SSLEngine srcEngine, SSLEngine dstEngine, ByteBuffer writeBuf, ByteBuffer readBuf) throws SSLException {
        ByteBuffer data = ByteBuffer.wrap(testData);
        SSLEngineResult result = srcEngine.wrap(data, writeBuf);
        if (result.getStatus() != SSLEngineResult.Status.OK) {
            throw new IllegalStateException("Can't wrap data: " + result);
        }
        if (data.hasRemaining()) {
            throw new IllegalStateException("Didn't wrap all data (" + testData + "): " + data);
        }
        writeBuf.flip();
        result = dstEngine.unwrap(writeBuf, readBuf);
        if (result.getStatus() != SSLEngineResult.Status.OK) {
            throw new IllegalStateException("Can't unwrap data: " + result);
        }
        if (writeBuf.hasRemaining()) {
            throw new IllegalStateException("Didn't unwrap all data!  readIn: " + writeBuf + ", made: " + readBuf);
        }
        byte[] read = Arrays.copyOf(readBuf.array(), readBuf.position());
        if (!Arrays.equals(testData, read)) {
            throw new IllegalStateException("Wrong data read!  Wanted: " + Arrays.asList(new byte[][]{testData}) + ", was: " + Arrays.asList(new byte[][]{read}));
        }
        readBuf.clear();
        writeBuf.clear();
    }

    public boolean isIgnorable(Throwable t) {
        if (this.causeIs(t, NoSuchAlgorithmException.class)) {
            return true;
        }
        if (t instanceof NoSuchMethodError) {
            return true;
        }
        if (t instanceof NoClassDefFoundError) {
            return true;
        }
        String msg = t.getMessage();
        return msg != null && msg.contains("Cipher buffering error");
    }

    private boolean causeIs(Throwable t, Class<? extends Throwable> causeClass) {
        while (t != null) {
            if (causeClass.isAssignableFrom(t.getClass())) {
                return true;
            }
            t = t.getCause();
        }
        return false;
    }
}

