/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.player.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class RandomAudioInputStream
extends InputStream {
    private final RandomAccessFile file;
    private long fileBytePosition;

    public RandomAudioInputStream(RandomAccessFile file) {
        this.file = file;
        this.fileBytePosition = 0L;
    }

    @Override
    public int read() throws IOException {
        int a = this.file.read();
        ++this.fileBytePosition;
        return a;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.file == null) {
            return -1;
        }
        int r = this.file.read(b, off, len);
        this.fileBytePosition += (long)r;
        return r;
    }

    @Override
    public int available() throws IOException {
        return (int)(this.file.length() - this.fileBytePosition);
    }

    @Override
    public long skip(long bytesToSkip) throws IOException {
        int bytes = this.file.skipBytes((int)bytesToSkip);
        this.fileBytePosition = bytes;
        return bytes;
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }
}

