/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.promotion.containers;

import java.util.Arrays;
import java.util.Date;
import org.limewire.io.BadGGEPBlockException;
import org.limewire.io.BadGGEPPropertyException;
import org.limewire.io.GGEP;
import org.limewire.promotion.containers.MessageContainer;
import org.limewire.util.StringUtils;

public abstract class MapMessageContainer
implements MessageContainer {
    private GGEP payload = new GGEP();

    protected void put(String key, String value) {
        if (value == null || key == null) {
            throw new NullPointerException("key and value must not be null.");
        }
        this.payload.put(key, StringUtils.toUTF8Bytes(value));
    }

    protected void put(String key, Date value) {
        if (value == null || key == null) {
            throw new NullPointerException("key and value must not be null.");
        }
        this.payload.put(key, value.getTime());
    }

    protected void put(String key, byte[] value) {
        if (value == null || key == null) {
            throw new NullPointerException("key and value must not be null.");
        }
        this.payload.put(key, value);
    }

    protected void put(String key, long value) {
        if (key == null) {
            throw new NullPointerException("key must not be null.");
        }
        this.payload.put(key, value);
    }

    protected String getString(String key) {
        if (key == null) {
            throw new NullPointerException("key must not be null.");
        }
        if (!this.payload.hasValueFor(key)) {
            return null;
        }
        return StringUtils.toUTF8String(this.payload.get(key));
    }

    protected byte[] getBytes(String key) {
        if (key == null) {
            throw new NullPointerException("key must not be null.");
        }
        if (!this.payload.hasValueFor(key)) {
            return null;
        }
        try {
            return this.payload.getBytes(key);
        }
        catch (BadGGEPPropertyException ex) {
            return null;
        }
    }

    protected Long getLong(String key) {
        if (key == null) {
            throw new NullPointerException("key must not be null.");
        }
        if (!this.payload.hasValueFor(key)) {
            return null;
        }
        try {
            return this.payload.getLong(key);
        }
        catch (BadGGEPPropertyException ex) {
            return null;
        }
    }

    protected Date getDate(String key) {
        if (key == null) {
            throw new NullPointerException("key must not be null.");
        }
        if (!this.payload.hasValueFor(key)) {
            return null;
        }
        try {
            return new Date(this.payload.getLong(key));
        }
        catch (BadGGEPPropertyException ex) {
            return null;
        }
    }

    @Override
    public byte[] encode() {
        this.payload.put("T", this.getType());
        return this.payload.toByteArray();
    }

    @Override
    public void decode(GGEP rawGGEP) throws BadGGEPBlockException {
        if (!Arrays.equals(this.getType(), rawGGEP.get("T"))) {
            throw new BadGGEPBlockException("Incorrect type.");
        }
        this.payload = rawGGEP;
    }
}

