/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.promotion.impressions;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.limewire.promotion.impressions.Impression;
import org.limewire.promotion.impressions.UserQueryEvent;
import org.limewire.util.ByteUtils;
import org.limewire.util.StringUtils;

public class UserQueryEventData {
    private final UserQueryEvent event;
    private final long millisSinceToday;

    public UserQueryEventData(UserQueryEvent event, long millisSinceToday) {
        this.event = event;
        this.millisSinceToday = millisSinceToday;
    }

    public UserQueryEventData(UserQueryEvent event) {
        this(event, UserQueryEventData.millisecondsSinceTheStartOfToday());
    }

    public String getQuery() {
        return this.event.getOriginalQuery();
    }

    public byte[] getData() {
        List<Impression> impressions = this.event.getImpressions();
        int length = 13;
        for (Impression imp : impressions) {
            ++length;
            length += StringUtils.toAsciiBytes(imp.getBinderUniqueName()).length;
            length += 8;
            length += 8;
        }
        byte[] bytes = new byte[length];
        AtomicInteger inc = new AtomicInteger(0);
        bytes[inc.getAndAdd((int)1)] = (byte)(0xFF & impressions.size());
        System.arraycopy(ByteUtils.long2bytes(this.millisSinceToday, 4), 0, bytes, inc.getAndAdd(4), 4);
        System.arraycopy(ByteUtils.long2bytes(this.event.getOriginalQueryTime().getTime(), 8), 0, bytes, inc.getAndAdd(8), 8);
        for (int i = 0; i < impressions.size(); ++i) {
            Impression imp = impressions.get(i);
            byte[] binderName = StringUtils.toAsciiBytes(imp.getBinderUniqueName());
            bytes[inc.getAndAdd((int)1)] = (byte)(0xFF & binderName.length);
            System.arraycopy(binderName, 0, bytes, inc.getAndAdd(binderName.length), binderName.length);
            System.arraycopy(ByteUtils.long2bytes(imp.getPromoUniqueID(), 8), 0, bytes, inc.getAndAdd(8), 8);
            System.arraycopy(ByteUtils.long2bytes(imp.getTimeShown().getTime(), 8), 0, bytes, inc.getAndAdd(8), 8);
        }
        return bytes;
    }

    long getMillisSinceToday() {
        return this.millisSinceToday;
    }

    static int millisecondsSinceTheStartOfToday() {
        return (int)(System.currentTimeMillis() - UserQueryEventData.getFirstMillisecond());
    }

    static long getFirstMillisecond() {
        int year = Calendar.getInstance().get(1);
        GregorianCalendar cal = new GregorianCalendar(year, 0, 1, 0, 0, 0);
        return cal.getTime().getTime();
    }
}

