/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.activation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.application.Resource;
import org.limewire.ui.swing.components.ColoredBusyLabel;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.ResizeUtils;

public class ActivationWarningPanel {
    private static int ICON_WIDTH = 16;
    @Resource
    private Icon warningIcon;
    private final JPanel panel;
    private ColoredBusyLabel busyLabel;
    private Mode currentMode = Mode.EMPTY;

    public ActivationWarningPanel() {
        GuiUtils.assignResources(this);
        this.panel = new JPanel(new BorderLayout());
        this.panel.setOpaque(false);
        this.panel.add(Box.createRigidArea(new Dimension(ICON_WIDTH, ICON_WIDTH)), "Center");
        ResizeUtils.forceSize(this.panel, new Dimension(ICON_WIDTH, ICON_WIDTH));
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public void setActivationMode(Mode mode) {
        if (this.currentMode == mode) {
            return;
        }
        if (this.currentMode == Mode.SPINNER) {
            this.busyLabel.setBusy(false);
            this.busyLabel = null;
        }
        this.currentMode = mode;
        this.panel.removeAll();
        switch (mode) {
            case WARNING: {
                this.panel.add((Component)new JLabel(this.warningIcon), "Center");
                break;
            }
            case SPINNER: {
                this.busyLabel = new ColoredBusyLabel(new Dimension(ICON_WIDTH, ICON_WIDTH));
                this.panel.add((Component)this.busyLabel, "Center");
                this.panel.revalidate();
                this.busyLabel.setBusy(true);
                break;
            }
            default: {
                this.panel.add(Box.createRigidArea(new Dimension(ICON_WIDTH, ICON_WIDTH)), "Center");
            }
        }
    }

    public static enum Mode {
        EMPTY,
        SPINNER,
        WARNING;

    }
}

