/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.advanced;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.limewire.core.api.mojito.MojitoManager;
import org.limewire.ui.swing.advanced.TabPanel;
import org.limewire.ui.swing.plugin.SwingUiPlugin;
import org.limewire.ui.swing.util.I18n;

class MojitoPanel
extends TabPanel {
    private final MojitoManager mojitoManager;
    private SwingUiPlugin plugin;
    private PropertyChangeListener dhtListener;
    private boolean dhtStarted;
    private JLabel dhtLabel = new JLabel();
    private JComponent dhtRenderer;

    @Inject
    public MojitoPanel(MojitoManager mojitoManager) {
        this.mojitoManager = mojitoManager;
        this.setBorder(BorderFactory.createEmptyBorder(3, 12, 12, 12));
        this.setLayout(new BorderLayout());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                if (MojitoPanel.this.dhtRenderer != null) {
                    MojitoPanel.this.dhtRenderer.requestFocusInWindow();
                }
            }
        });
        this.dhtLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 3, 0));
        this.dhtLabel.setHorizontalAlignment(0);
    }

    @Inject(optional=true)
    void register(@Named(value="MojitoArcsPlugin") SwingUiPlugin mojitoPlugin) {
        this.plugin = mojitoPlugin;
    }

    @Override
    public boolean isTabEnabled() {
        return this.plugin != null && this.dhtStarted;
    }

    @Override
    public void initData() {
        if (this.plugin != null) {
            this.renderPlugin();
        } else {
            this.renderNotAvailable();
        }
        this.dhtStarted = this.mojitoManager.isRunning();
        this.dhtLabel.setText(this.mojitoManager.getName());
        this.fireEnabledChanged(this.isTabEnabled());
        if (this.dhtListener == null) {
            this.dhtListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if ("started".equals(e.getPropertyName())) {
                        boolean wasStarted = MojitoPanel.this.dhtStarted;
                        MojitoPanel.this.dhtStarted = (Boolean)e.getNewValue();
                        MojitoPanel.this.dhtLabel.setText(MojitoPanel.this.mojitoManager.getName());
                        if (MojitoPanel.this.dhtStarted && !wasStarted && MojitoPanel.this.plugin != null) {
                            MojitoPanel.this.renderPlugin();
                        }
                        MojitoPanel.this.fireEnabledChanged(MojitoPanel.this.isTabEnabled());
                    }
                }
            };
            this.mojitoManager.addPropertyChangeListener(this.dhtListener);
        }
    }

    private void renderPlugin() {
        this.dhtRenderer = this.plugin.getPluginComponent();
        if (this.dhtRenderer != null) {
            this.removeAll();
            this.add((Component)this.dhtLabel, "North");
            this.add((Component)this.dhtRenderer, "Center");
        } else {
            this.renderNotAvailable();
        }
        this.plugin.startPlugin();
    }

    private void renderNotAvailable() {
        this.removeAll();
        this.dhtRenderer = null;
        JLabel naLabel = new JLabel();
        naLabel.setText(I18n.tr("Mojito Arcs View not available"));
        naLabel.setHorizontalAlignment(0);
        naLabel.setVerticalAlignment(0);
        this.add((Component)naLabel, "Center");
    }

    @Override
    public void dispose() {
        if (this.plugin != null) {
            this.plugin.stopPlugin();
        }
        if (this.dhtListener != null) {
            this.mojitoManager.removePropertyChangeListener(this.dhtListener);
            this.dhtListener = null;
        }
    }
}

