/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import org.jdesktop.application.Resource;
import org.limewire.ui.swing.components.VolumeSliderUI;
import org.limewire.ui.swing.util.GuiUtils;

public class VolumeSlider
extends JSlider {
    @Resource
    private Color background;
    @Resource
    private Color borderForeground;

    public VolumeSlider() {
        this(0, 100);
    }

    public VolumeSlider(int min, int max) {
        super(min, max);
        GuiUtils.assignResources(this);
        this.initSlider();
    }

    private void initSlider() {
        this.setBackground(this.background);
        this.setOrientation(1);
        this.addKeyListener(new VolumeKeyListener());
    }

    @Override
    public void updateUI() {
        this.setUI(new VolumeSliderUI(this));
        this.updateLabelUIs();
    }

    public JPopupMenu createPopup() {
        JPopupMenu popup = new JPopupMenu(){

            @Override
            public void requestFocus() {
                VolumeSlider.this.requestFocus();
            }
        };
        popup.setBorder(BorderFactory.createLineBorder(this.borderForeground));
        popup.setLayout(new BorderLayout());
        popup.add((Component)this, "Center");
        return popup;
    }

    private class VolumeKeyListener
    extends KeyAdapter {
        private VolumeKeyListener() {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            switch (e.getKeyCode()) {
                case 36: {
                    VolumeSlider.this.setValue(VolumeSlider.this.getMaximum());
                    break;
                }
                case 35: {
                    VolumeSlider.this.setValue(VolumeSlider.this.getMinimum());
                }
            }
        }
    }
}

