/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.dnd;

import com.google.inject.Inject;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.jdesktop.application.Resource;
import org.limewire.inject.LazySingleton;
import org.limewire.ui.swing.util.GuiUtils;

@LazySingleton
public class GhostDragGlassPane
extends JPanel {
    @Resource
    private Icon dragIconAccept;
    @Resource
    private Icon dragIconReject;
    private Icon dragIcon;
    private float alpha = 0.85f;
    private BufferedImage dragged = null;
    private Point location = new Point(0, 0);
    private Point oldLocation = new Point(0, 0);
    private int width;
    private int height;
    private Rectangle visibleRect = null;

    @Inject
    public GhostDragGlassPane() {
        this.setOpaque(false);
        GuiUtils.assignResources(this);
        this.dragIcon = this.dragIconAccept;
        this.updateDragImage();
    }

    private void updateDragImage() {
        this.dragged = new BufferedImage(this.dragIcon.getIconWidth(), this.dragIcon.getIconHeight(), 2);
        Graphics g = this.dragged.getGraphics();
        g.drawImage(((ImageIcon)this.dragIcon).getImage(), 0, 0, null);
        this.width = this.dragIcon.getIconWidth();
        this.height = this.dragIcon.getIconHeight();
    }

    public void setPoint(Point location) {
        this.oldLocation = this.location;
        this.location = location;
    }

    public Rectangle getRepaintRect() {
        int x = (int)this.location.getX();
        int y = (int)(this.location.getY() - (double)(this.height / 2));
        int x2 = (int)this.oldLocation.getX();
        int y2 = (int)(this.oldLocation.getY() - (double)(this.height / 2));
        return new Rectangle(x, y, this.width, this.height).union(new Rectangle(x2, y2, this.width, this.height));
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.dragged == null || !this.isVisible()) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setComposite(AlphaComposite.getInstance(3, this.alpha));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int x = (int)this.location.getX();
        int y = (int)(this.location.getY() - (double)(this.height / 2));
        if (this.visibleRect != null) {
            g2.setClip(this.visibleRect);
        }
        g2.drawImage(this.dragged, x, y, this.width, this.height, null);
        g2.dispose();
    }

    public void setAccept(boolean accept) {
        Icon oldIcon = this.dragIcon;
        Icon icon = this.dragIcon = accept ? this.dragIconAccept : this.dragIconReject;
        if (this.dragIcon != oldIcon) {
            this.updateDragImage();
            this.repaint();
        }
    }
}

