/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.downloads;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.limewire.collection.glazedlists.GlazedListsFactory;
import org.limewire.core.api.URN;
import org.limewire.core.api.download.DownloadItem;
import org.limewire.core.api.download.DownloadListManager;
import org.limewire.core.api.download.DownloadState;
import org.limewire.core.settings.SharingSettings;
import org.limewire.inject.LazySingleton;
import org.limewire.inspection.DataCategory;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectableContainer;
import org.limewire.inspection.InspectableForSize;
import org.limewire.inspection.InspectablePrimitive;
import org.limewire.inspection.InspectionPoint;
import org.limewire.setting.evt.SettingEvent;
import org.limewire.setting.evt.SettingListener;
import org.limewire.ui.swing.components.HyperlinkButton;
import org.limewire.ui.swing.downloads.DownloadHeaderPopupMenu;
import org.limewire.ui.swing.downloads.DownloadStateComparator;
import org.limewire.ui.swing.downloads.MainDownloadPanel;
import org.limewire.ui.swing.downloads.table.DownloadStateExcluder;
import org.limewire.ui.swing.downloads.table.DownloadStateMatcher;
import org.limewire.ui.swing.settings.SwingUiSettings;
import org.limewire.ui.swing.transfer.TransferTrayNavigator;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.SwingUtils;
import org.limewire.util.FileUtils;

@LazySingleton
public class DownloadMediator {
    @InspectableForSize(value="download count", category=DataCategory.USAGE)
    private final SortedList<DownloadItem> commonBaseList;
    private final DownloadListManager downloadListManager;
    private final Provider<MainDownloadPanel> downloadPanelFactory;
    private final Provider<DownloadHeaderPopupMenu> headerPopupMenuFactory;
    private final Provider<TransferTrayNavigator> transferTrayNavigator;
    private EventList<DownloadItem> activeList;
    private JButton clearFinishedButton;
    private JButton fixStalledButton;
    private List<JButton> headerButtons;
    private DownloadHeaderPopupMenu headerPopupMenu;
    @InspectablePrimitive(value="download sorts", category=DataCategory.USAGE)
    private final Set<SortOrder> sortInspection = new HashSet<SortOrder>();

    @Inject
    public DownloadMediator(DownloadListManager downloadManager, Provider<MainDownloadPanel> downloadPanelFactory, Provider<DownloadHeaderPopupMenu> headerPopupMenuFactory, Provider<TransferTrayNavigator> transferTrayNavigator) {
        this.downloadListManager = downloadManager;
        this.downloadPanelFactory = downloadPanelFactory;
        this.headerPopupMenuFactory = headerPopupMenuFactory;
        this.transferTrayNavigator = transferTrayNavigator;
        FilterList<DownloadItem> baseList = GlazedListsFactory.filterList(downloadManager.getSwingThreadSafeDownloads(), new DownloadStateExcluder(DownloadState.CANCELLED, new DownloadState[0]));
        this.commonBaseList = GlazedListsFactory.sortedList(baseList, this.getSortComparator(this.getSortOrder(), this.isSortAscending()));
    }

    @Inject
    void register() {
        this.downloadListManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("downloadAdded".equals(evt.getPropertyName())) {
                    ((TransferTrayNavigator)DownloadMediator.this.transferTrayNavigator.get()).selectDownloads();
                }
            }
        });
        SharingSettings.CLEAR_DOWNLOAD.addSettingListener(new SettingListener(){

            @Override
            public void settingChanged(SettingEvent evt) {
                SwingUtils.invokeNowOrLater(new Runnable(){

                    @Override
                    public void run() {
                        boolean clearDownloads = SharingSettings.CLEAR_DOWNLOAD.getValue();
                        if (clearDownloads) {
                            DownloadMediator.this.clearFinished();
                        }
                        if (DownloadMediator.this.clearFinishedButton != null) {
                            DownloadMediator.this.clearFinishedButton.setVisible(!clearDownloads);
                        }
                    }
                });
            }
        });
        FilterList<DownloadItem> doneList = GlazedListsFactory.filterList(this.getDownloadList(), new DownloadStateMatcher(DownloadState.DONE, DownloadState.DANGEROUS, DownloadState.THREAT_FOUND, DownloadState.SCAN_FAILED));
        FilterList<DownloadItem> stalledList = GlazedListsFactory.filterList(this.getDownloadList(), new DownloadStateMatcher(DownloadState.STALLED, new DownloadState[0]));
        doneList.addListEventListener(new ListEventListener<DownloadItem>(){

            @Override
            public void listChanged(ListEvent<DownloadItem> listChanges) {
                if (DownloadMediator.this.clearFinishedButton != null) {
                    DownloadMediator.this.clearFinishedButton.setEnabled(listChanges.getSourceList().size() > 0);
                }
            }
        });
        stalledList.addListEventListener(new ListEventListener<DownloadItem>(){

            @Override
            public void listChanged(ListEvent<DownloadItem> listChanges) {
                if (DownloadMediator.this.fixStalledButton != null) {
                    DownloadMediator.this.fixStalledButton.setVisible(listChanges.getSourceList().size() != 0);
                }
            }
        });
    }

    public JComponent getComponent() {
        return this.downloadPanelFactory.get();
    }

    public boolean isSortAscending() {
        return SwingUiSettings.DOWNLOAD_SORT_ASCENDING.getValue();
    }

    public SortOrder getSortOrder() {
        try {
            String sortKey = SwingUiSettings.DOWNLOAD_SORT_KEY.get();
            return SortOrder.valueOf(sortKey);
        }
        catch (IllegalArgumentException ex) {
            return SortOrder.ORDER_ADDED;
        }
    }

    public void setSortOrder(SortOrder order, boolean isAscending) {
        SwingUiSettings.DOWNLOAD_SORT_KEY.set(order.toString());
        SwingUiSettings.DOWNLOAD_SORT_ASCENDING.setValue(isAscending);
        this.commonBaseList.setComparator(this.getSortComparator(order, isAscending));
        this.sortInspection.add(order);
    }

    private Comparator<DownloadItem> getSortComparator(SortOrder sortOrder, boolean ascending) {
        Comparator<DownloadItem> comparator;
        switch (sortOrder) {
            case ORDER_ADDED: {
                comparator = new OrderAddedComparator();
                break;
            }
            case NAME: {
                comparator = new NameComparator();
                break;
            }
            case PROGRESS: {
                comparator = new ProgressComparator();
                break;
            }
            case TIME_REMAINING: {
                comparator = new TimeRemainingComparator();
                break;
            }
            case SPEED: {
                comparator = new SpeedComparator();
                break;
            }
            case STATUS: {
                comparator = new DownloadStateComparator();
                break;
            }
            case FILE_TYPE: {
                comparator = new FileTypeComparator();
                break;
            }
            case EXTENSION: {
                comparator = new FileExtensionComparator();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown SortOrder: " + (Object)((Object)sortOrder));
            }
        }
        if (ascending) {
            return comparator;
        }
        return new DescendingComparator(comparator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseAll() {
        this.commonBaseList.getReadWriteLock().writeLock().lock();
        try {
            for (DownloadItem item : this.commonBaseList) {
                if (!item.getState().isPausable()) continue;
                item.pause();
            }
        }
        finally {
            this.commonBaseList.getReadWriteLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeAll() {
        this.commonBaseList.getReadWriteLock().writeLock().lock();
        try {
            for (DownloadItem item : this.commonBaseList) {
                if (!item.getState().isResumable()) continue;
                item.resume();
            }
        }
        finally {
            this.commonBaseList.getReadWriteLock().writeLock().unlock();
        }
    }

    public EventList<DownloadItem> getActiveList() {
        if (this.activeList == null) {
            this.activeList = GlazedListsFactory.filterList(this.commonBaseList, new DownloadStateExcluder(DownloadState.ERROR, DownloadState.DONE, DownloadState.CANCELLED, DownloadState.DANGEROUS, DownloadState.THREAT_FOUND, DownloadState.SCAN_FAILED));
        }
        return this.activeList;
    }

    public EventList<DownloadItem> getDownloadList() {
        return this.commonBaseList;
    }

    public List<JButton> getHeaderButtons() {
        if (this.headerButtons == null) {
            this.fixStalledButton = new HyperlinkButton(new FixStalledAction());
            this.fixStalledButton.setVisible(false);
            this.clearFinishedButton = new HyperlinkButton(new ClearFinishedAction());
            this.clearFinishedButton.setEnabled(false);
            this.headerButtons = new ArrayList<JButton>();
            this.headerButtons.add(this.fixStalledButton);
            this.headerButtons.add(this.clearFinishedButton);
        }
        return this.headerButtons;
    }

    public JPopupMenu getHeaderPopupMenu() {
        if (this.headerPopupMenu == null) {
            this.headerPopupMenu = this.headerPopupMenuFactory.get();
            this.headerPopupMenu.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                    DownloadMediator.this.headerPopupMenu.removeAll();
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    DownloadMediator.this.headerPopupMenu.removeAll();
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    DownloadMediator.this.headerPopupMenu.populate();
                }
            });
        }
        return this.headerPopupMenu;
    }

    public void clearFinished() {
        this.downloadListManager.clearFinished();
    }

    public void fixStalled() {
        List<DownloadItem> items = this.getMatchingDownloadItems(DownloadState.STALLED);
        for (DownloadItem item : items) {
            item.resume();
        }
    }

    public void cancelStalled() {
        this.cancelMatchingDownloadItems(DownloadState.STALLED);
    }

    public void cancelError() {
        this.cancelMatchingDownloadItems(DownloadState.ERROR);
    }

    public void cancelAll() {
        this.cancelMatchingDownloadItems(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasResumable() {
        this.commonBaseList.getReadWriteLock().writeLock().lock();
        try {
            for (DownloadItem item : this.commonBaseList) {
                if (!item.getState().isResumable()) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.commonBaseList.getReadWriteLock().writeLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPausable() {
        this.commonBaseList.getReadWriteLock().writeLock().lock();
        try {
            for (DownloadItem item : this.commonBaseList) {
                if (!item.getState().isPausable()) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.commonBaseList.getReadWriteLock().writeLock().unlock();
        }
        return false;
    }

    public boolean containsState(DownloadState state) {
        return this.getMatchingDownloadItems(state).size() > 0;
    }

    private void cancelMatchingDownloadItems(DownloadState state) {
        List<DownloadItem> items = this.getMatchingDownloadItems(state);
        for (DownloadItem item : items) {
            item.cancel();
        }
    }

    private List<DownloadItem> getMatchingDownloadItems(DownloadState state) {
        if (state == null) {
            return new ArrayList<DownloadItem>(this.commonBaseList);
        }
        ArrayList<DownloadItem> matchingItems = new ArrayList<DownloadItem>();
        for (DownloadItem item : this.commonBaseList) {
            if (item.getState() != state) continue;
            matchingItems.add(item);
        }
        return matchingItems;
    }

    public void selectAndScrollTo(URN urn) {
        this.transferTrayNavigator.get().selectDownloads();
        this.downloadPanelFactory.get().selectAndScrollTo(urn);
    }

    private static class DescendingComparator
    implements Comparator<DownloadItem> {
        private Comparator<DownloadItem> delegate;

        public DescendingComparator(Comparator<DownloadItem> delegate) {
            this.delegate = delegate;
        }

        @Override
        public int compare(DownloadItem o1, DownloadItem o2) {
            return -1 * this.delegate.compare(o1, o2);
        }
    }

    private static class FileExtensionComparator
    implements Comparator<DownloadItem> {
        private FileExtensionComparator() {
        }

        @Override
        public int compare(DownloadItem o1, DownloadItem o2) {
            if (o1 == o2) {
                return 0;
            }
            return FileUtils.getFileExtension(o1.getDownloadingFile()).compareTo(FileUtils.getFileExtension(o2.getDownloadingFile()));
        }
    }

    private static class FileTypeComparator
    implements Comparator<DownloadItem> {
        private FileTypeComparator() {
        }

        @Override
        public int compare(DownloadItem o1, DownloadItem o2) {
            if (o1 == o2) {
                return 0;
            }
            return o1.getCategory().compareTo(o2.getCategory());
        }
    }

    private static class SpeedComparator
    implements Comparator<DownloadItem> {
        private SpeedComparator() {
        }

        @Override
        public int compare(DownloadItem o1, DownloadItem o2) {
            if (o1 == o2) {
                return 0;
            }
            return (int)o2.getDownloadSpeed() - (int)o1.getDownloadSpeed();
        }
    }

    private static class TimeRemainingComparator
    implements Comparator<DownloadItem> {
        private TimeRemainingComparator() {
        }

        @Override
        public int compare(DownloadItem o1, DownloadItem o2) {
            if (o1 == o2) {
                return 0;
            }
            return (int)(o1.getRemainingDownloadTime() - o2.getRemainingDownloadTime());
        }
    }

    private static class ProgressComparator
    implements Comparator<DownloadItem> {
        private ProgressComparator() {
        }

        @Override
        public int compare(DownloadItem o1, DownloadItem o2) {
            if (o1 == o2) {
                return 0;
            }
            return o1.getPercentComplete() - o2.getPercentComplete();
        }
    }

    private static class NameComparator
    implements Comparator<DownloadItem> {
        private NameComparator() {
        }

        @Override
        public int compare(DownloadItem o1, DownloadItem o2) {
            if (o1 == o2) {
                return 0;
            }
            return o1.getTitle().compareTo(o2.getTitle());
        }
    }

    private static class OrderAddedComparator
    implements Comparator<DownloadItem> {
        private OrderAddedComparator() {
        }

        @Override
        public int compare(DownloadItem o1, DownloadItem o2) {
            if (o1 == o2) {
                return 0;
            }
            return o2.getStartDate().compareTo(o1.getStartDate());
        }
    }

    private class FixStalledAction
    extends AbstractAction {
        public FixStalledAction() {
            super(I18n.tr("Fix Stalled"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DownloadMediator.this.fixStalled();
        }
    }

    private class ClearFinishedAction
    extends AbstractAction {
        public ClearFinishedAction() {
            super(I18n.tr("Clear Finished"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DownloadMediator.this.clearFinished();
        }
    }

    @InspectableContainer
    private class LazyInspectableContainer {
        @InspectionPoint(value="active downloads", category=DataCategory.USAGE)
        private final Inspectable activeDownloads = new Inspectable(){

            @Override
            public Object inspect() {
                return DownloadMediator.this.getActiveList().size();
            }
        };

        private LazyInspectableContainer() {
        }
    }

    public static enum SortOrder {
        ORDER_ADDED,
        NAME,
        PROGRESS,
        TIME_REMAINING,
        SPEED,
        STATUS,
        FILE_TYPE,
        EXTENSION;

    }
}

