/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.downloads.table.renderer;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.limewire.core.api.download.DownloadItem;
import org.limewire.core.api.download.DownloadState;
import org.limewire.ui.swing.components.HyperlinkButton;
import org.limewire.ui.swing.transfer.TransferRendererResources;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;

public class DownloadButtonPanel
extends JPanel {
    private final JButton pauseButton;
    private final JButton resumeButton;
    private final JButton tryAgainButton;
    private final JButton searchAgainButton;

    public DownloadButtonPanel() {
        this((ActionListener)null);
    }

    public DownloadButtonPanel(ActionListener actionListener) {
        super(new MigLayout("insets 0 0 0 0, gap 0, novisualpadding, fill, aligny center"));
        GuiUtils.assignResources(this);
        this.setOpaque(false);
        Font font = new TransferRendererResources().getFont();
        this.pauseButton = new HyperlinkButton(I18n.tr("Pause"));
        this.pauseButton.setActionCommand("pause");
        this.pauseButton.addActionListener(actionListener);
        this.pauseButton.setToolTipText(I18n.tr("Pause download"));
        this.pauseButton.setFont(font);
        this.tryAgainButton = new HyperlinkButton(I18n.tr("Try again"));
        this.tryAgainButton.setActionCommand("try again");
        this.tryAgainButton.addActionListener(actionListener);
        this.tryAgainButton.setToolTipText(I18n.tr("Try again"));
        this.tryAgainButton.setFont(font);
        this.resumeButton = new HyperlinkButton(I18n.tr("Resume"));
        this.resumeButton.setActionCommand("resume");
        this.resumeButton.addActionListener(actionListener);
        this.resumeButton.setVisible(false);
        this.resumeButton.setToolTipText(I18n.tr("Resume download"));
        this.resumeButton.setFont(font);
        this.searchAgainButton = new HyperlinkButton(I18n.tr("Search Again"));
        this.searchAgainButton.setActionCommand("search again");
        this.searchAgainButton.addActionListener(actionListener);
        this.resumeButton.setVisible(false);
        this.searchAgainButton.setToolTipText(I18n.tr("Search Again"));
        this.searchAgainButton.setFont(font);
        this.add((Component)this.resumeButton, "hidemode 3");
        this.add((Component)this.pauseButton, "hidemode 3");
        this.add((Component)this.tryAgainButton, "hidemode 3");
        this.add((Component)this.searchAgainButton, "hidemode 3");
    }

    public void addActionListener(ActionListener actionListener) {
        this.pauseButton.addActionListener(actionListener);
        this.resumeButton.addActionListener(actionListener);
        this.tryAgainButton.addActionListener(actionListener);
        this.searchAgainButton.addActionListener(actionListener);
    }

    public void updateButtons(DownloadItem item) {
        if (item.getDownloadItemType() != DownloadItem.DownloadItemType.ANTIVIRUS) {
            DownloadState state = item.getState();
            boolean canTryAgain = item.isTryAgainEnabled();
            this.pauseButton.setVisible(state == DownloadState.DOWNLOADING);
            this.resumeButton.setVisible(state.isResumable());
            this.tryAgainButton.setVisible(state == DownloadState.STALLED && canTryAgain);
            this.searchAgainButton.setVisible(state == DownloadState.STALLED && !canTryAgain && !item.isStoreDownload());
        } else {
            this.pauseButton.setVisible(false);
            this.resumeButton.setVisible(false);
            this.tryAgainButton.setVisible(false);
            this.searchAgainButton.setVisible(false);
        }
    }
}

