/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.filter;

import org.limewire.ui.swing.util.I18n;
import org.limewire.util.Objects;

class SourceItem {
    public static final SourceItem ANONYMOUS_SOURCE = new SourceItem(Type.ANONYMOUS, I18n.tr("P2P Users"));
    public static final SourceItem ANY_FRIEND_SOURCE = new SourceItem(Type.ANY_FRIEND, I18n.tr("Any Friend"));
    private final Type type;
    private final String name;

    public SourceItem(Type type, String name) {
        this.type = type;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SourceItem) {
            SourceItem item2 = (SourceItem)obj;
            if (this.type == item2.type) {
                return Objects.compareToNullIgnoreCase(this.name, item2.name, false) == 0;
            }
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.type.hashCode();
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    public static enum Type {
        ANONYMOUS,
        ANY_FRIEND,
        FRIEND;

    }
}

