/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.filter;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.UniqueList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.util.concurrent.Lock;
import java.util.Comparator;

public class UniqueListFactory<E> {
    private final EventList<E> sourceList;
    private final EventList<E> mirrorList;
    private final UniqueList<E> uniqueList;
    private final ListEventListener<E> sourceListener;
    private String name;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UniqueListFactory(EventList<E> sourceList, Comparator<E> comparator) {
        this.sourceList = sourceList;
        this.mirrorList = new BasicEventList();
        this.uniqueList = new UniqueList<E>(this.mirrorList, comparator);
        this.sourceListener = new SourceEventListener();
        Lock lock = sourceList.getReadWriteLock().readLock();
        lock.lock();
        try {
            this.mirrorList.addAll(sourceList);
            sourceList.addListEventListener(this.sourceListener);
        }
        finally {
            lock.unlock();
        }
    }

    public void dispose() {
        this.sourceList.removeListEventListener(this.sourceListener);
        this.uniqueList.dispose();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UniqueList<E> getUniqueList() {
        return this.uniqueList;
    }

    private class SourceEventListener
    implements ListEventListener<E> {
        private SourceEventListener() {
        }

        @Override
        public void listChanged(ListEvent<E> listChanges) {
            EventList sourceList = listChanges.getSourceList();
            while (listChanges.next()) {
                int index = listChanges.getIndex();
                int type = listChanges.getType();
                try {
                    switch (type) {
                        case 2: {
                            UniqueListFactory.this.mirrorList.add(index, sourceList.get(index));
                            break;
                        }
                        case 0: {
                            UniqueListFactory.this.mirrorList.remove(index);
                            break;
                        }
                        case 1: {
                            UniqueListFactory.this.mirrorList.set(index, sourceList.get(index));
                        }
                    }
                }
                catch (Throwable th) {
                    throw new RuntimeException(this.createExceptionMessage(type, index), th);
                }
            }
        }

        private String createExceptionMessage(int type, int index) {
            StringBuilder buf = new StringBuilder();
            buf.append(UniqueListFactory.this.getName()).append(" list, unable to ");
            switch (type) {
                case 2: {
                    buf.append("insert");
                    break;
                }
                case 0: {
                    buf.append("delete");
                    break;
                }
                case 1: {
                    buf.append("update");
                }
            }
            buf.append(" at index ").append(index);
            return buf.toString();
        }
    }
}

