/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.friends.chat;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.Map;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.FormSubmitEvent;
import org.limewire.core.api.download.DownloadAction;
import org.limewire.core.api.download.DownloadException;
import org.limewire.core.api.download.DownloadItem;
import org.limewire.core.api.download.DownloadState;
import org.limewire.core.api.download.ResultDownloader;
import org.limewire.core.api.friend.FileMetaDataConverter;
import org.limewire.core.api.search.SearchResult;
import org.limewire.io.InvalidDataException;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.ui.swing.components.FocusJOptionPane;
import org.limewire.ui.swing.friends.chat.ChatFriend;
import org.limewire.ui.swing.friends.chat.Conversation;
import org.limewire.ui.swing.friends.chat.MessageFileOffer;
import org.limewire.ui.swing.util.DownloadExceptionHandler;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.NativeLaunchUtils;

class ChatHyperlinkListener
implements HyperlinkListener {
    private static final Log LOG = LogFactory.getLog(ChatHyperlinkListener.class);
    private Conversation conversation;
    private final ResultDownloader downloader;
    private final FileMetaDataConverter remoteFileItemFactory;
    private final Provider<DownloadExceptionHandler> downloadExceptionHandler;

    @Inject
    public ChatHyperlinkListener(@Assisted Conversation conversation, ResultDownloader downloader, FileMetaDataConverter remoteFileItemFactory, Provider<DownloadExceptionHandler> downloadExceptionHandler) {
        this.conversation = conversation;
        this.downloader = downloader;
        this.remoteFileItemFactory = remoteFileItemFactory;
        this.downloadExceptionHandler = downloadExceptionHandler;
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e instanceof FormSubmitEvent) {
            FormSubmitEvent event = (FormSubmitEvent)e;
            LOG.debugf("File offer download requested. FileId: {0}", (Object)event.getData());
            try {
                String dataStr = event.getData();
                String fileIdEncoded = dataStr.substring(dataStr.indexOf("=") + 1).trim();
                String fileId = URLDecoder.decode(fileIdEncoded, "UTF-8");
                this.downloadFileOffer(fileId);
            }
            catch (UnsupportedEncodingException uee) {
                throw new RuntimeException(uee);
            }
        } else if (HyperlinkEvent.EventType.ACTIVATED == e.getEventType()) {
            this.handleLinkClick(e.getDescription(), e.getURL());
        }
    }

    void downloadFileOffer(String fileId) {
        Map<String, MessageFileOffer> fileOffers = this.conversation.getFileOfferMessages();
        MessageFileOffer msgWithfileOffer = fileOffers.get(fileId);
        SearchResult file = null;
        try {
            file = this.remoteFileItemFactory.create(msgWithfileOffer.getPresence(), msgWithfileOffer.getFileOffer());
            DownloadItem dl = this.downloader.addDownload(null, Collections.singletonList(file));
            this.addPropertyListener(dl, msgWithfileOffer);
        }
        catch (DownloadException e) {
            final SearchResult remoteFileItem = file;
            final MessageFileOffer messageFileOffer = msgWithfileOffer;
            this.downloadExceptionHandler.get().handleDownloadException(new DownloadAction(){

                @Override
                public void download(File saveFile, boolean overwrite) throws DownloadException {
                    DownloadItem dl = ChatHyperlinkListener.this.downloader.addDownload(null, Collections.singletonList(remoteFileItem), saveFile, overwrite);
                    ChatHyperlinkListener.this.addPropertyListener(dl, messageFileOffer);
                }

                @Override
                public void downloadCanceled(DownloadException ignored) {
                }
            }, e, true);
        }
        catch (InvalidDataException ide) {
            LOG.error("Unable to access remote file", ide);
            FocusJOptionPane.showMessageDialog(null, I18n.tr("Unable to access remote file"), I18n.tr("Hyperlink"), 2);
        }
    }

    private void handleLinkClick(String linkDescription, URL url) {
        if ("#library".equals(linkDescription)) {
            ChatFriend libraryChatFriend = this.conversation.getChatFriend();
            LOG.debugf("Opening a view to {0}'s library", (Object)libraryChatFriend.getName());
            throw new IllegalStateException("action does't exist");
        }
        if ("#mylibrary".equals(linkDescription)) {
            LOG.debugf("Opening a view to my library", new Object[0]);
            throw new IllegalStateException("action does't exist");
        }
        LOG.debugf("Hyperlink clicked: {0}", (Object)linkDescription);
        if (!linkDescription.startsWith("magnet") && url != null) {
            NativeLaunchUtils.openURL(url.toString());
        }
    }

    private void addPropertyListener(DownloadItem dl, final MessageFileOffer msgWithfileOffer) {
        dl.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("state".equals(evt.getPropertyName())) {
                    DownloadState state = (DownloadState)((Object)evt.getNewValue());
                    msgWithfileOffer.setDownloadState(state);
                    ChatHyperlinkListener.this.conversation.displayMessages();
                }
            }
        });
    }
}

