/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.friends.login;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.concurrent.ExecutionException;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.limewire.concurrent.FutureEvent;
import org.limewire.concurrent.ListeningFuture;
import org.limewire.friend.api.FriendConnection;
import org.limewire.friend.api.FriendConnectionFactory;
import org.limewire.friend.api.FriendException;
import org.limewire.inject.EagerSingleton;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.listener.EventListener;
import org.limewire.listener.SwingEDTEvent;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.ui.swing.friends.login.LoginPopupPanel;
import org.limewire.ui.swing.friends.settings.FriendAccountConfiguration;
import org.limewire.ui.swing.friends.settings.FriendAccountConfigurationManager;

@EagerSingleton
public class AutoLoginService
implements Service {
    private static final Log LOG = LogFactory.getLog(AutoLoginService.class);
    private final FriendAccountConfigurationManager accountManager;
    private volatile boolean hasAttemptedLogin = false;
    private final FriendConnectionFactory friendConnectionFactory;
    private final Provider<LoginPopupPanel> friendsSignInPanel;

    @Inject
    public AutoLoginService(FriendAccountConfigurationManager accountManager, FriendConnectionFactory friendConnectionFactory, Provider<LoginPopupPanel> friendsSignInPanel) {
        this.accountManager = accountManager;
        this.friendConnectionFactory = friendConnectionFactory;
        this.friendsSignInPanel = friendsSignInPanel;
    }

    public boolean hasLoginConfig() {
        return this.accountManager.getAutoLoginConfig() != null;
    }

    public boolean hasAttemptedLogin() {
        return this.hasAttemptedLogin;
    }

    public boolean isAttemptingLogin() {
        return !this.hasAttemptedLogin() && this.hasLoginConfig();
    }

    @Inject
    void register(ServiceRegistry registry) {
        registry.register(this);
    }

    @Override
    public String getServiceName() {
        return "Auto-Login Serivce";
    }

    @Override
    public void initialize() {
    }

    @Override
    public void start() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (AutoLoginService.this.hasLoginConfig()) {
                    final FriendAccountConfiguration config = AutoLoginService.this.accountManager.getAutoLoginConfig();
                    ListeningFuture<FriendConnection> connectionListenerFuture = AutoLoginService.this.friendConnectionFactory.login(config);
                    connectionListenerFuture.addFutureListener(new EventListener<FutureEvent<FriendConnection>>(){

                        @Override
                        @SwingEDTEvent
                        public void handleEvent(FutureEvent<FriendConnection> event) {
                            if (event.getType() == FutureEvent.Type.EXCEPTION) {
                                ExecutionException exception = event.getException();
                                if (exception.getCause() instanceof FriendException) {
                                    LoginPopupPanel loginPanel = (LoginPopupPanel)AutoLoginService.this.friendsSignInPanel.get();
                                    loginPanel.setVisible(true);
                                    Action login = loginPanel.getServiceSelectionLoginPanel().getLoginActions().get(config);
                                    login.actionPerformed(null);
                                } else {
                                    LOG.debug("auto-login failed", exception);
                                }
                            }
                        }
                    });
                }
                AutoLoginService.this.hasAttemptedLogin = true;
            }
        });
    }

    @Override
    public void stop() {
    }
}

