/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.friends.login;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.MatteBorder;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.JXPanel;
import org.limewire.core.settings.FriendSettings;
import org.limewire.ui.swing.components.Disposable;
import org.limewire.ui.swing.components.PopupHeaderBar;
import org.limewire.ui.swing.components.Resizable;
import org.limewire.ui.swing.friends.login.ServiceSelectionLoginPanel;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.ResizeUtils;

@Singleton
public class LoginPopupPanel
extends Panel
implements Resizable {
    @Resource
    private Dimension size;
    @Resource
    private Color background;
    @Resource
    private Color border;
    @Resource
    private Font titleBarFont;
    @Resource
    private Icon windowIcon;
    private final Provider<ServiceSelectionLoginPanel> serviceSelectionLoginPanelProvider;
    private volatile ServiceSelectionLoginPanel serviceSelectionLoginPanel;
    private JXPanel frame = null;
    private JPanel contentPanel = null;

    @Inject
    public LoginPopupPanel(Provider<ServiceSelectionLoginPanel> serviceSelectionLoginPanelProvider) {
        this.serviceSelectionLoginPanelProvider = serviceSelectionLoginPanelProvider;
        GuiUtils.assignResources(this);
        this.setLayout(new BorderLayout());
        this.setVisible(false);
    }

    private void initContent() {
        this.frame = new JXPanel(new BorderLayout());
        this.frame.setPreferredSize(this.size);
        this.frame.setBackground(this.background);
        PopupHeaderBar headerBar = new PopupHeaderBar(I18n.tr("File sharing with friends"), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LoginPopupPanel.this.finished();
            }
        });
        headerBar.setIcon(this.windowIcon);
        headerBar.setFont(this.titleBarFont);
        ResizeUtils.forceHeight(headerBar, 23);
        this.contentPanel = new JPanel(new BorderLayout());
        this.contentPanel.setOpaque(false);
        this.frame.add((Component)headerBar, "North");
        this.frame.add((Component)this.contentPanel, "Center");
        this.frame.setBorder(new MatteBorder(0, 3, 3, 3, this.border));
        this.add((Component)this.frame, "Center");
    }

    @Override
    public void resize() {
        Rectangle parentBounds = this.getParent().getBounds();
        Dimension childPreferredSize = this.frame.getPreferredSize();
        int w = (int)childPreferredSize.getWidth();
        int h = (int)childPreferredSize.getHeight();
        this.setBounds((int)parentBounds.getWidth() / 2 - w / 2, (int)parentBounds.getHeight() / 2 - h / 2 + 20, w, h);
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.frame == null && visible) {
            FriendSettings.EVER_OPENED_SIGN_IN_DIALOG.setValue(true);
            this.initContent();
            this.start();
            this.resize();
            this.repaint();
            this.validate();
        } else if (visible && !this.isVisible()) {
            this.restart();
        } else if (!visible && this.contentPanel != null) {
            this.clearContentPanel();
            this.serviceSelectionLoginPanel = null;
        }
        super.setVisible(visible);
    }

    public void start() {
        this.serviceSelectionLoginPanel = this.serviceSelectionLoginPanelProvider.get();
        this.contentPanel.add((Component)this.serviceSelectionLoginPanel, "Center");
    }

    public void restart() {
        this.clearContentPanel();
        this.start();
        this.contentPanel.repaint();
        this.contentPanel.validate();
    }

    public void finished() {
        this.setVisible(false);
    }

    public void setLoginComponent(JComponent loginPanel) {
        this.clearContentPanel();
        this.contentPanel.add((Component)loginPanel, "Center");
        loginPanel.requestFocusInWindow();
        this.contentPanel.repaint();
        this.contentPanel.validate();
    }

    private void clearContentPanel() {
        if (this.contentPanel != null) {
            for (Component component : this.contentPanel.getComponents()) {
                if (!(component instanceof Disposable)) continue;
                ((Disposable)((Object)component)).dispose();
            }
            this.contentPanel.removeAll();
        }
    }

    public ServiceSelectionLoginPanel getServiceSelectionLoginPanel() {
        return this.serviceSelectionLoginPanel;
    }
}

