/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.library;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.SwingUtilities;
import org.limewire.core.api.Category;
import org.limewire.core.api.URN;
import org.limewire.core.api.download.DownloadItem;
import org.limewire.core.api.download.DownloadState;
import org.limewire.core.api.library.LibraryManager;
import org.limewire.core.api.library.LocalFileItem;
import org.limewire.core.api.library.SharedFileList;
import org.limewire.inject.LazySingleton;
import org.limewire.ui.swing.library.LibraryPanel;
import org.limewire.ui.swing.library.navigator.LibraryNavItem;
import org.limewire.ui.swing.nav.NavCategory;
import org.limewire.ui.swing.nav.NavItem;
import org.limewire.ui.swing.nav.NavMediator;
import org.limewire.ui.swing.nav.Navigator;

@LazySingleton
public class LibraryMediator
implements NavMediator<LibraryPanel> {
    public static final String NAME = "Library";
    private Provider<LibraryPanel> libraryProvider;
    private LibraryPanel libraryPanel;
    private final Provider<Navigator> navigatorProvider;
    private final Provider<LibraryManager> libraryManager;

    @Inject
    public LibraryMediator(Provider<LibraryPanel> libraryProvider, Provider<Navigator> navigatorProvider, Provider<LibraryManager> libraryManager) {
        this.libraryProvider = libraryProvider;
        this.navigatorProvider = navigatorProvider;
        this.libraryManager = libraryManager;
    }

    @Override
    public LibraryPanel getComponent() {
        if (this.libraryPanel == null) {
            this.libraryPanel = this.libraryProvider.get();
        }
        return this.libraryPanel;
    }

    public void selectInLibrary(File file) {
        final File firstFile = this.findFile(file);
        this.showLibrary();
        this.clearFilters();
        this.getComponent().selectLocalFileList(this.libraryManager.get().getLibraryManagedList());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LibraryMediator.this.getComponent().selectAndScrollTo(firstFile);
            }
        });
    }

    private File findFile(File file) {
        File firstFile = file;
        if (firstFile.isDirectory()) {
            ArrayList<File> accumulator = new ArrayList<File>(Arrays.asList(firstFile));
            while (accumulator.size() > 0) {
                File folderOrFile = (File)accumulator.remove(0);
                if (folderOrFile.isDirectory()) {
                    File[] files = folderOrFile.listFiles();
                    if (files == null) continue;
                    accumulator.addAll(Arrays.asList(files));
                    continue;
                }
                return folderOrFile;
            }
        }
        return firstFile;
    }

    private void showLibrary() {
        NavItem item = this.navigatorProvider.get().getNavItem(NavCategory.LIBRARY, NAME);
        item.select();
    }

    public void selectAndRenameSharedList(final SharedFileList sharedFileList) {
        assert (!sharedFileList.isPublic());
        this.showLibrary();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LibraryMediator.this.getComponent().editSharedListName(sharedFileList);
            }
        });
    }

    public void selectInLibrary(final URN urn) {
        NavItem item = this.navigatorProvider.get().getNavItem(NavCategory.LIBRARY, NAME);
        item.select();
        this.getComponent().selectLocalFileList(this.libraryManager.get().getLibraryManagedList());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LibraryMediator.this.getComponent().selectAndScrollTo(urn);
            }
        });
    }

    public void showSharedFileList(SharedFileList list) {
        this.showSharedFileList(list, false);
    }

    public void showSharedFileList(final SharedFileList list, final boolean showEditingMode) {
        NavItem item = this.navigatorProvider.get().getNavItem(NavCategory.LIBRARY, NAME);
        item.select();
        this.getComponent();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LibraryMediator.this.getComponent().selectLocalFileList(list);
                if (showEditingMode) {
                    LibraryMediator.this.getComponent().showEditMode();
                }
            }
        });
    }

    public boolean isInitialized() {
        return this.libraryPanel != null;
    }

    public void clearFilters() {
        this.getComponent().clearFilters();
    }

    public LibraryNavItem getSelectedNavItem() {
        return this.getComponent().getSelectedNavItem();
    }

    public Category getSelectedCategory() {
        return this.getComponent().getSelectedCategory();
    }

    public List<LocalFileItem> getPlayableList() {
        return this.getComponent().getPlayableList();
    }

    public List<LocalFileItem> getSelectedItems() {
        return this.getComponent().getSelectedItems();
    }

    public void locateInLibrary(DownloadItem item) {
        File file = item.getState() == DownloadState.DONE || item.getState() == DownloadState.SCAN_FAILED ? item.getLaunchableFile() : item.getDownloadingFile();
        URN urn = item.getUrn();
        if (file != null) {
            this.selectInLibrary(file);
        } else if (urn != null) {
            this.selectInLibrary(urn);
        }
    }
}

