/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.options;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;
import org.limewire.bittorrent.TorrentManager;
import org.limewire.bittorrent.TorrentManagerSettings;
import org.limewire.bittorrent.TorrentSettingsAnnotation;
import org.limewire.core.settings.ConnectionSettings;
import org.limewire.ui.swing.options.OptionPanel;
import org.limewire.ui.swing.table.AbstractTableFormat;
import org.limewire.ui.swing.util.BackgroundExecutorService;
import org.limewire.ui.swing.util.I18n;

public class NetworkInterfaceOptionPanel
extends OptionPanel {
    private ButtonGroup buttonGroup;
    private JRadioButton limewireChooseRadioButton;
    private JRadioButton meChooseRadioButton;
    private NetworkTable table;
    private JScrollPane scrollPane;
    private NetworkItem selectedItem;
    private EventList<NetworkItem> eventList;
    private final Provider<TorrentManager> torrentManager;
    private final TorrentManagerSettings torrentSettings;

    @Inject
    public NetworkInterfaceOptionPanel(Provider<TorrentManager> torrentManager, @TorrentSettingsAnnotation TorrentManagerSettings torrentSettings) {
        this.torrentManager = torrentManager;
        this.torrentSettings = torrentSettings;
        this.setLayout(new MigLayout("insets 15, fillx, wrap"));
        this.setOpaque(false);
        this.add((Component)this.getNetworkPanel(), "pushx, growx");
    }

    private JPanel getNetworkPanel() {
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createTitledBorder(""));
        p.setLayout(new MigLayout("fillx, gapy 10"));
        p.setOpaque(false);
        this.limewireChooseRadioButton = new JRadioButton(I18n.tr("Let LimeWire choose my network interface (Recommended)"));
        this.meChooseRadioButton = new JRadioButton(I18n.tr("Let me choose a specific network interface"));
        this.limewireChooseRadioButton.setOpaque(false);
        this.meChooseRadioButton.setOpaque(false);
        this.buttonGroup = new ButtonGroup();
        this.buttonGroup.add(this.limewireChooseRadioButton);
        this.buttonGroup.add(this.meChooseRadioButton);
        this.eventList = GlazedLists.threadSafeList(new BasicEventList());
        this.table = new NetworkTable(new DefaultEventTableModel<NetworkItem>(this.eventList, new NetworkTableFormat()));
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.setVisible(false);
        this.meChooseRadioButton.addItemListener(new RadioListener(this.scrollPane, this.meChooseRadioButton));
        p.add((Component)this.limewireChooseRadioButton, "wrap");
        p.add((Component)this.meChooseRadioButton, "wrap");
        p.add((Component)this.scrollPane, "grow, span");
        return p;
    }

    @Override
    boolean applyOptions() {
        ConnectionSettings.CUSTOM_NETWORK_INTERFACE.setValue(this.meChooseRadioButton.isSelected());
        for (NetworkItem item : this.eventList) {
            if (!item.isSelected()) continue;
            ConnectionSettings.CUSTOM_INETADRESS.set(item.getAddress());
            break;
        }
        if (this.torrentManager.get().isInitialized() && this.torrentManager.get().isValid()) {
            BackgroundExecutorService.execute(new Runnable(){

                @Override
                public void run() {
                    ((TorrentManager)NetworkInterfaceOptionPanel.this.torrentManager.get()).setTorrentManagerSettings(NetworkInterfaceOptionPanel.this.torrentSettings);
                }
            });
        }
        return false;
    }

    @Override
    boolean hasChanged() {
        if (!ConnectionSettings.CUSTOM_NETWORK_INTERFACE.getValue()) {
            return !this.limewireChooseRadioButton.isSelected();
        }
        String expect = ConnectionSettings.CUSTOM_INETADRESS.get();
        Iterator i$ = this.eventList.iterator();
        if (i$.hasNext()) {
            NetworkItem item = (NetworkItem)i$.next();
            if (expect.equals(item.getAddress())) {
                // empty if block
            }
            return false;
        }
        return true;
    }

    @Override
    public void initOptions() {
        this.eventList.clear();
        this.limewireChooseRadioButton.setSelected(!ConnectionSettings.CUSTOM_NETWORK_INTERFACE.getValue());
        this.meChooseRadioButton.setSelected(ConnectionSettings.CUSTOM_NETWORK_INTERFACE.getValue());
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface ni = interfaces.nextElement();
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (address.isAnyLocalAddress() || address.isLinkLocalAddress() || address.isLoopbackAddress()) continue;
                    NetworkItem networkItem = new NetworkItem(address, ni.getDisplayName());
                    if (ConnectionSettings.CUSTOM_INETADRESS.get().equals(address.getHostAddress())) {
                        networkItem.setSelected(true);
                        this.selectedItem = networkItem;
                    }
                    this.eventList.add(networkItem);
                }
            }
            if (this.selectedItem == null && this.eventList.size() > 0) {
                ((NetworkItem)this.eventList.get(0)).setSelected(true);
                this.selectedItem = (NetworkItem)this.eventList.get(0);
            }
        }
        catch (SocketException e) {
            this.meChooseRadioButton.setEnabled(false);
        }
        if (this.eventList.size() == 0) {
            this.meChooseRadioButton.setEnabled(false);
        }
    }

    private class CheckBoxRenderer
    extends JRadioButton
    implements TableCellRenderer,
    TableCellEditor {
        private final List<CellEditorListener> listeners = new ArrayList<CellEditorListener>();

        public CheckBoxRenderer() {
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NetworkItem currentItem = (NetworkItem)NetworkInterfaceOptionPanel.this.eventList.get(NetworkInterfaceOptionPanel.this.table.getSelectedRow());
                    if (!currentItem.getAddress().equals(NetworkInterfaceOptionPanel.this.selectedItem.getAddress())) {
                        NetworkInterfaceOptionPanel.this.selectedItem.setSelected(false);
                        NetworkInterfaceOptionPanel.this.selectedItem = currentItem;
                    }
                    currentItem.setSelected(true);
                    CheckBoxRenderer.this.cancelCellEditing();
                    NetworkInterfaceOptionPanel.this.table.repaint();
                }
            });
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof NetworkItem) {
                NetworkItem item = (NetworkItem)value;
                this.setSelected(item.isSelected);
            } else {
                this.setSelected(false);
            }
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            return this;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return this.getTableCellRendererComponent(table, value, true, true, row, column);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancelCellEditing() {
            List<CellEditorListener> list = this.listeners;
            synchronized (list) {
                int N = this.listeners.size();
                for (int i = 0; i < N; ++i) {
                    this.listeners.get(i).editingCanceled(new ChangeEvent(this));
                }
            }
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeCellEditorListener(CellEditorListener lis) {
            List<CellEditorListener> list = this.listeners;
            synchronized (list) {
                if (this.listeners.contains(lis)) {
                    this.listeners.remove(lis);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addCellEditorListener(CellEditorListener lis) {
            List<CellEditorListener> list = this.listeners;
            synchronized (list) {
                if (!this.listeners.contains(lis)) {
                    this.listeners.add(lis);
                }
            }
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            this.cancelCellEditing();
            return true;
        }
    }

    private static class NetworkItem {
        private boolean isSelected = false;
        private InetAddress address;
        private String displayName;

        public NetworkItem(InetAddress address, String displayName) {
            this.address = address;
            this.displayName = displayName;
        }

        public String getAddress() {
            return this.address.getHostAddress();
        }

        public String getName() {
            return this.displayName;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public void setSelected(boolean value) {
            this.isSelected = value;
        }
    }

    private static class NetworkTableFormat
    extends AbstractTableFormat<NetworkItem> {
        private static final int CHECK_INDEX = 0;
        private static final int ADDRESS_INDEX = 1;
        private static final int NAME_INDEX = 2;

        public NetworkTableFormat() {
            super("", I18n.tr("Address"), I18n.tr("Name"));
        }

        @Override
        public Object getColumnValue(NetworkItem baseObject, int column) {
            switch (column) {
                case 0: {
                    return baseObject;
                }
                case 1: {
                    return baseObject.getAddress();
                }
                case 2: {
                    return baseObject.getName();
                }
            }
            throw new IllegalStateException("Unknown column:" + column);
        }
    }

    private class NetworkTable
    extends JXTable {
        public NetworkTable(DefaultEventTableModel<NetworkItem> model) {
            super(model);
            this.setShowGrid(false, false);
            this.setColumnSelectionAllowed(false);
            this.getColumn(0).setCellRenderer(new CheckBoxRenderer());
            this.getColumn(0).setCellEditor(new CheckBoxRenderer());
            this.getColumn(0).setMaxWidth(30);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (row >= this.getRowCount() || col >= this.getColumnCount() || row < 0 || col < 0) {
                return false;
            }
            return this.getColumnModel().getColumn(col).getCellEditor() != null;
        }
    }

    private static class RadioListener
    implements ItemListener {
        private JScrollPane scrollPane;
        private JRadioButton radioButton;

        public RadioListener(JScrollPane scrollPane, JRadioButton button) {
            this.scrollPane = scrollPane;
            this.radioButton = button;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            this.scrollPane.setVisible(this.radioButton.isSelected());
        }
    }
}

