/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.painter;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.jdesktop.swingx.util.PaintUtils;
import org.limewire.ui.swing.util.PainterUtils;

public class BorderPainter<X>
extends AbstractPainter<X> {
    private final int arcWidth;
    private final int arcHeight;
    private final Paint border;
    private final Paint bevelTop1;
    private final Paint bevelTop2;
    private final Paint bevelBottom;
    private Paint bevelLeft;
    private Paint bevelRight;
    private int tabHeightCache = -1;
    private final Paint accentPaint1;
    private final Paint accentPaint2;
    private final Paint accentPaint3;
    private Insets insets = PainterUtils.BLANK_INSETS;
    private final AccentType accentType;
    private static final Paint BUBBLE_PAINT1 = new Color(0xEEEEEE);
    private static final Paint BUBBLE_PAINT2 = new Color(0xEDEDED);
    private static final Paint BUBBLE_PAINT3 = new Color(0xF0F0F0);
    private static final Paint SHADOW_PAINT1 = new Color(0x5F5F5F);
    private static final Paint SHADOW_PAINT2 = new Color(0x5E5E5E);
    private static final Paint SHADOW_PAINT3 = new Color(0x646464);
    private static final Paint GREEN_SHADOW_PAINT1 = new Color(12835233);
    private static final Paint GREEN_SHADOW_PAINT2 = new Color(12179341);
    private static final Paint GREEN_SHADOW_PAINT3 = new Color(0xE1EECC);

    public BorderPainter(int arcWidth, int arcHeight, Paint border, Paint bevelLeft, Paint bevelTop1, Paint bevelTop2, Paint bevelRight, Paint bevelBottom, AccentType accentType) {
        this.arcWidth = arcWidth;
        this.arcHeight = arcHeight;
        this.border = border;
        this.bevelLeft = bevelLeft;
        this.bevelTop1 = bevelTop1;
        this.bevelTop2 = bevelTop2;
        this.bevelRight = bevelRight;
        this.bevelBottom = bevelBottom;
        this.accentType = accentType;
        switch (accentType) {
            case BUBBLE: {
                this.accentPaint1 = BUBBLE_PAINT1;
                this.accentPaint2 = BUBBLE_PAINT2;
                this.accentPaint3 = BUBBLE_PAINT3;
                break;
            }
            case SHADOW: {
                this.accentPaint1 = SHADOW_PAINT1;
                this.accentPaint2 = SHADOW_PAINT2;
                this.accentPaint3 = SHADOW_PAINT3;
                break;
            }
            case GREEN_SHADOW: {
                this.accentPaint1 = GREEN_SHADOW_PAINT1;
                this.accentPaint2 = GREEN_SHADOW_PAINT2;
                this.accentPaint3 = GREEN_SHADOW_PAINT3;
                break;
            }
            default: {
                this.accentPaint1 = PainterUtils.TRASPARENT;
                this.accentPaint2 = PainterUtils.TRASPARENT;
                this.accentPaint3 = PainterUtils.TRASPARENT;
            }
        }
        this.setCacheable(true);
    }

    public int getArcHeight() {
        return this.arcHeight;
    }

    public int getArcWidth() {
        return this.arcWidth;
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
    }

    @Override
    protected void doPaint(Graphics2D g, X object, int width, int height) {
        int ix1 = this.insets.left;
        int ix2 = this.insets.right;
        int singleArcHeight = this.arcHeight / 2;
        g.setClip(0 + ix1, 0, width - 2 - ix1 - ix2, 7);
        g.setPaint(this.bevelTop2);
        g.drawRoundRect(1 + ix1, 2, width - 2 - ix1 - ix2, height - 5, this.arcWidth, this.arcHeight);
        g.setPaint(this.bevelTop1);
        g.drawRoundRect(1 + ix1, 1, width - 3 - ix1 - ix2, height - 4, this.arcWidth, this.arcHeight);
        if (this.tabHeightCache != height) {
            this.bevelLeft = PaintUtils.resizeGradient(this.bevelLeft, 0, height - singleArcHeight + 1);
            this.bevelRight = PaintUtils.resizeGradient(this.bevelRight, 0, height - singleArcHeight + 1);
            this.tabHeightCache = height;
        }
        g.setClip(0 + ix1, singleArcHeight, width - 2 - ix1 - ix2, height);
        g.setPaint(this.bevelBottom);
        g.drawRoundRect(1 + ix1, 1, width - 4 - ix1 - ix2, height - 4, this.arcWidth, this.arcHeight);
        g.setClip(0 + ix1, singleArcHeight - 1, width - 2 - ix1 - ix2, height);
        g.setPaint(this.bevelLeft);
        g.drawLine(2 + ix1, singleArcHeight - 1, 2 + ix1, height - singleArcHeight);
        g.setPaint(this.bevelRight);
        g.drawLine(width - 3 - ix2, singleArcHeight - 1, width - 3 - ix2, height - singleArcHeight);
        if (this.accentType != AccentType.NONE) {
            g.setClip(0 + ix1, singleArcHeight, width - ix1 - ix2, height);
            g.setPaint(this.accentPaint3);
            g.drawRoundRect(0 + ix1, 0, width - 1 - ix1 - ix2, height - 1, this.arcWidth, this.arcHeight);
            g.setPaint(this.accentPaint2);
            g.drawLine(0 + ix1, singleArcHeight, 0 + ix1, height / 2);
            g.drawLine(width - 1 - ix2, singleArcHeight, width - 1 - ix2, height / 2);
            g.setPaint(this.accentPaint1);
            g.drawLine(0 + ix1, height / 2, 0 + ix1, height - singleArcHeight);
            g.drawLine(width - 1 - ix2, height / 2, width - 1 - ix2, height - singleArcHeight);
        }
        g.setClip(0 + ix1, 0, width - ix1 - ix2, height);
        g.setPaint(PaintUtils.resizeGradient(this.border, 0, height));
        g.drawRoundRect(1 + ix1, 0, width - 3 - ix1 - ix2, height - 2, this.arcWidth, this.arcHeight);
        if (ix1 < 0) {
            g.drawLine(0, 1, 0, height - 2);
        }
        if (ix2 < 0) {
            GradientPaint spanGradient = new GradientPaint(0.0f, 1.0f, PainterUtils.getColour(this.bevelTop1), 0.0f, height - 3, PainterUtils.getColour(this.bevelBottom), false);
            g.setPaint(spanGradient);
            g.drawLine(width - 1, 2, width - 1, height - 3);
        }
    }

    public static enum AccentType {
        SHADOW,
        GREEN_SHADOW,
        BUBBLE,
        NONE;

    }
}

