/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.pro;

import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.limewire.activation.api.ActivationManager;
import org.limewire.activation.api.ModuleCodeEvent;
import org.limewire.concurrent.FutureEvent;
import org.limewire.core.api.Application;
import org.limewire.core.settings.InstallSettings;
import org.limewire.listener.EventListener;
import org.limewire.listener.SwingEDTEvent;
import org.limewire.ui.swing.components.HTMLPane;
import org.limewire.ui.swing.components.PanelResizer;
import org.limewire.ui.swing.components.Resizable;
import org.limewire.ui.swing.pro.ProNag;
import org.limewire.ui.swing.statusbar.ProStatusPanel;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.SwingUtils;

public class ProNagController {
    private final boolean isFirstLaunch = !InstallSettings.UPGRADED_TO_5.getValue();
    private final ProNag proNag;
    private final ProStatusPanel proStatusPanel;
    private final ActivationManager activationManager;
    private MCodeListener listener;
    private boolean waitingForMCode = true;
    private JLayeredPane layeredPane;
    private boolean nagShown;

    @Inject
    ProNagController(ProNag proNag, ProStatusPanel proStatusPanel, ActivationManager activationManager, Application application) {
        this.proNag = proNag;
        this.proStatusPanel = proStatusPanel;
        this.activationManager = activationManager;
        this.waitingForMCode = !activationManager.isMCodeUpToDate();
    }

    @Inject
    public void register() {
        if (!this.activationManager.isMCodeUpToDate()) {
            this.listener = new MCodeListener();
            this.activationManager.addMCodeListener(this.listener);
        } else {
            this.waitingForMCode = !this.activationManager.isMCodeUpToDate();
        }
    }

    public void showNagIfReady(final JLayeredPane layeredPane) {
        SwingUtils.invokeNowOrLater(new Runnable(){

            @Override
            public void run() {
                ProNagController.this.layeredPane = layeredPane;
                if (ProNagController.this.isNagReady()) {
                    ProNagController.this.showNag();
                }
            }
        });
    }

    private boolean isNagReady() {
        return !this.waitingForMCode && this.layeredPane != null;
    }

    private void showNag() {
        if (!this.nagShown) {
            assert (SwingUtilities.isEventDispatchThread());
            this.nagShown = true;
            this.proNag.loadContents(this.isFirstLaunch).addFutureListener(new EventListener<FutureEvent<HTMLPane.LoadResult>>(){

                @Override
                @SwingEDTEvent
                public void handleEvent(FutureEvent<HTMLPane.LoadResult> event) {
                    switch (event.getType()) {
                        case SUCCESS: {
                            if (!ProNagController.this.proNag.hasContent()) break;
                            ActionListener listener = new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    if (ProNagController.this.proNag.isModal()) {
                                        ProNagController.this.loadModalNag();
                                    } else {
                                        ProNagController.this.loadNonModalNag(ProNagController.this.layeredPane);
                                    }
                                }
                            };
                            int delay = ProNagController.this.proNag.getDelay();
                            if (delay > 0) {
                                Timer timer = new Timer(delay, listener);
                                timer.setRepeats(false);
                                timer.start();
                                break;
                            }
                            listener.actionPerformed(null);
                        }
                    }
                }
            });
        }
    }

    private void loadModalNag() {
        final JDialog dialog = new JDialog((Window)GuiUtils.getMainFrame(), Dialog.ModalityType.APPLICATION_MODAL);
        dialog.setDefaultCloseOperation(2);
        dialog.setResizable(false);
        this.proNag.setContainer(new ProNag.NagContainer(){

            @Override
            public void dispose() {
                dialog.dispose();
            }
        });
        if (this.proNag.isUndecorated()) {
            dialog.setUndecorated(true);
        }
        if (this.proNag.getTitle() != null) {
            dialog.setTitle(this.proNag.getTitle());
        }
        dialog.getContentPane().add(this.proNag);
        dialog.pack();
        dialog.setLocationRelativeTo(GuiUtils.getMainFrame());
        this.proStatusPanel.addCondition(ProStatusPanel.InvisibilityCondition.PRO_ADD_SHOWN);
        dialog.setVisible(true);
        this.proStatusPanel.removeCondition(ProStatusPanel.InvisibilityCondition.PRO_ADD_SHOWN);
    }

    private void loadNonModalNag(final JLayeredPane layeredPane) {
        final Panel heavyweight = new Panel(new BorderLayout());
        Resizable resizable = new Resizable(){

            @Override
            public void resize() {
                Rectangle parentBounds = heavyweight.getParent().getBounds();
                Dimension childPreferredSize = heavyweight.getPreferredSize();
                int w = childPreferredSize.width;
                int h = childPreferredSize.height;
                heavyweight.setBounds(parentBounds.width / 2 - w / 2, parentBounds.height - h, w, h);
            }

            @Override
            public boolean isVisible() {
                return ProNagController.this.proNag.isVisible();
            }
        };
        heavyweight.add(this.proNag);
        final PanelResizer resizer = new PanelResizer(resizable);
        layeredPane.addComponentListener(resizer);
        layeredPane.add((Component)heavyweight, JLayeredPane.MODAL_LAYER);
        resizable.resize();
        this.proStatusPanel.addCondition(ProStatusPanel.InvisibilityCondition.PRO_ADD_SHOWN);
        this.proNag.setContainer(new ProNag.NagContainer(){

            @Override
            public void dispose() {
                heavyweight.setVisible(false);
                layeredPane.remove(heavyweight);
                layeredPane.removeComponentListener(resizer);
                ProNagController.this.proStatusPanel.removeCondition(ProStatusPanel.InvisibilityCondition.PRO_ADD_SHOWN);
            }
        });
    }

    private class MCodeListener
    implements EventListener<ModuleCodeEvent> {
        private MCodeListener() {
        }

        @Override
        @SwingEDTEvent
        public void handleEvent(ModuleCodeEvent event) {
            ProNagController.this.waitingForMCode = false;
            if (ProNagController.this.isNagReady()) {
                ProNagController.this.showNag();
            }
        }
    }
}

