/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.properties;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import org.limewire.bittorrent.Torrent;
import org.limewire.core.api.download.DownloadItem;
import org.limewire.core.api.library.LibraryManager;
import org.limewire.core.api.library.MagnetLinkFactory;
import org.limewire.core.api.library.MetaDataManager;
import org.limewire.core.api.library.PropertiableFile;
import org.limewire.core.api.library.SharedFileListManager;
import org.limewire.core.api.properties.PropertyDictionary;
import org.limewire.core.api.spam.SpamManager;
import org.limewire.ui.swing.components.decorators.TableDecorator;
import org.limewire.ui.swing.library.LibraryMediator;
import org.limewire.ui.swing.painter.factories.BarPainterFactory;
import org.limewire.ui.swing.properties.FileInfoBittorrentOverviewPanel;
import org.limewire.ui.swing.properties.FileInfoBittorrentPanel;
import org.limewire.ui.swing.properties.FileInfoDialog;
import org.limewire.ui.swing.properties.FileInfoGeneralPanel;
import org.limewire.ui.swing.properties.FileInfoOverviewPanel;
import org.limewire.ui.swing.properties.FileInfoPanel;
import org.limewire.ui.swing.properties.FileInfoPanelFactory;
import org.limewire.ui.swing.properties.FileInfoPiecesPanel;
import org.limewire.ui.swing.properties.FileInfoSharingPanel;
import org.limewire.ui.swing.properties.FileInfoTrackersPanel;
import org.limewire.ui.swing.properties.FileInfoTransfersPanel;
import org.limewire.ui.swing.util.CategoryIconManager;
import org.limewire.ui.swing.util.IconManager;

@Singleton
public class FileInfoPanelFactoryImpl
implements FileInfoPanelFactory {
    private final Provider<IconManager> iconManager;
    private final Provider<MagnetLinkFactory> magnetLinkFactory;
    private final Provider<CategoryIconManager> categoryIconManager;
    private final Provider<PropertyDictionary> propertyDictionary;
    private final Provider<SpamManager> spamManager;
    private final Provider<SharedFileListManager> sharedFileListManager;
    private final Provider<MetaDataManager> metaDataManager;
    private final Provider<LibraryMediator> libraryMediator;
    private final Provider<LibraryManager> libraryManager;
    private final Provider<BarPainterFactory> barPainterFactory;
    private final Provider<TableDecorator> tableDecorator;

    @Inject
    public FileInfoPanelFactoryImpl(Provider<IconManager> iconManager, Provider<MagnetLinkFactory> magnetLinkFactory, Provider<CategoryIconManager> categoryIconManager, Provider<PropertyDictionary> propertyDictionary, Provider<SpamManager> spamManager, Provider<SharedFileListManager> sharedFileListManager, Provider<MetaDataManager> metaDataManager, Provider<LibraryMediator> libraryMediator, Provider<LibraryManager> libraryManager, Provider<BarPainterFactory> barPainterFactory, Provider<TableDecorator> tableDecorator) {
        this.iconManager = iconManager;
        this.magnetLinkFactory = magnetLinkFactory;
        this.categoryIconManager = categoryIconManager;
        this.propertyDictionary = propertyDictionary;
        this.spamManager = spamManager;
        this.sharedFileListManager = sharedFileListManager;
        this.metaDataManager = metaDataManager;
        this.libraryMediator = libraryMediator;
        this.libraryManager = libraryManager;
        this.barPainterFactory = barPainterFactory;
        this.tableDecorator = tableDecorator;
    }

    @Override
    public FileInfoBittorrentPanel createBittorentPanel(Torrent torrent) {
        return new FileInfoBittorrentPanel(torrent);
    }

    @Override
    public FileInfoPanel createOverviewPanel(Torrent torrent) {
        return new FileInfoBittorrentOverviewPanel(torrent);
    }

    @Override
    public FileInfoPanel createGeneralPanel(FileInfoDialog.FileInfoType type, PropertiableFile propertiableFile) {
        return new FileInfoGeneralPanel(type, propertiableFile, this.propertyDictionary.get(), this.spamManager.get(), this.metaDataManager.get(), this.libraryMediator.get());
    }

    @Override
    public FileInfoPanel createOverviewPanel(FileInfoDialog.FileInfoType type, PropertiableFile propertiableFile) {
        return new FileInfoOverviewPanel(type, propertiableFile, this.iconManager, this.magnetLinkFactory.get(), this.categoryIconManager.get(), this.libraryManager.get(), this.barPainterFactory.get());
    }

    @Override
    public FileInfoPanel createSharingPanel(FileInfoDialog.FileInfoType type, PropertiableFile propertiableFile) {
        return new FileInfoSharingPanel(type, propertiableFile, this.sharedFileListManager.get());
    }

    @Override
    public FileInfoPanel createTrackersPanel(FileInfoDialog.FileInfoType type, PropertiableFile propertiableFile) {
        return new FileInfoTrackersPanel(type, propertiableFile, this.tableDecorator.get());
    }

    @Override
    public FileInfoPanel createTransferPanel(FileInfoDialog.FileInfoType type, PropertiableFile propertiableFile) {
        return new FileInfoTransfersPanel(type, propertiableFile, this.tableDecorator.get());
    }

    @Override
    public FileInfoPanel createPiecesPanel(FileInfoDialog.FileInfoType type, DownloadItem propertiableFile) {
        return new FileInfoPiecesPanel(type, propertiableFile);
    }
}

