/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.search;

import java.util.Collections;
import java.util.Map;
import org.limewire.core.api.FilePropertyKey;
import org.limewire.core.api.search.SearchCategory;
import org.limewire.core.api.search.SearchDetails;
import org.limewire.ui.swing.search.SearchInfo;
import org.limewire.ui.swing.util.I18n;
import org.limewire.util.StringUtils;

public class DefaultSearchInfo
implements SearchInfo {
    private final String title;
    private final String query;
    private final SearchCategory searchCategory;
    private final SearchDetails.SearchType searchType;
    private final Map<FilePropertyKey, String> advancedSearch;

    public static DefaultSearchInfo createKeywordSearch(String query, SearchCategory searchCategory) {
        return new DefaultSearchInfo(query, query, Collections.<FilePropertyKey, String>emptyMap(), searchCategory, SearchDetails.SearchType.KEYWORD);
    }

    public static DefaultSearchInfo createAdvancedSearch(String title, Map<FilePropertyKey, String> advancedSearch, SearchCategory searchCategory) {
        return new DefaultSearchInfo(title, "", advancedSearch, searchCategory, SearchDetails.SearchType.KEYWORD);
    }

    public static DefaultSearchInfo createBrowseSearch(SearchDetails.SearchType type) {
        assert (type.isBrowse());
        return new DefaultSearchInfo("", "", Collections.<FilePropertyKey, String>emptyMap(), SearchCategory.ALL, type);
    }

    public static DefaultSearchInfo createWhatsNewSearch(SearchCategory searchCategory) {
        String title;
        switch (searchCategory) {
            case AUDIO: {
                title = I18n.tr("New audio");
                break;
            }
            case DOCUMENT: {
                title = I18n.tr("New documents");
                break;
            }
            case IMAGE: {
                title = I18n.tr("New images");
                break;
            }
            case PROGRAM: {
                title = I18n.tr("New programs");
                break;
            }
            case VIDEO: {
                title = I18n.tr("New videos");
                break;
            }
            default: {
                title = I18n.tr("New files");
            }
        }
        return new DefaultSearchInfo(title, null, Collections.<FilePropertyKey, String>emptyMap(), searchCategory, SearchDetails.SearchType.WHATS_NEW);
    }

    private DefaultSearchInfo(String title, String query, Map<FilePropertyKey, String> advancedSearch, SearchCategory searchCategory, SearchDetails.SearchType searchType) {
        this.title = title;
        this.query = query;
        this.advancedSearch = advancedSearch;
        this.searchCategory = searchCategory;
        this.searchType = searchType;
    }

    @Override
    public String getSearchQuery() {
        return this.query;
    }

    @Override
    public Map<FilePropertyKey, String> getAdvancedDetails() {
        return this.advancedSearch;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public SearchCategory getSearchCategory() {
        return this.searchCategory;
    }

    @Override
    public SearchDetails.SearchType getSearchType() {
        return this.searchType;
    }

    public String toString() {
        return StringUtils.toString(this, new Object[0]);
    }
}

