/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.search;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import org.limewire.collection.SortedList;
import org.limewire.core.api.FilePropertyKey;
import org.limewire.core.api.search.SearchCategory;
import org.limewire.i18n.I18nMarker;
import org.limewire.ui.swing.search.DefaultSearchInfo;
import org.limewire.ui.swing.search.SearchCategoryUtils;
import org.limewire.ui.swing.search.SearchInfo;
import org.limewire.ui.swing.util.FilePropertyKeyUtils;
import org.limewire.ui.swing.util.Translator;

@Singleton
public class KeywordAssistedSearchBuilder {
    private static final String UNTRANSLATED_SEPARATOR = I18nMarker.marktr(":");
    private static final boolean CHECK_FORMAT = true;
    private final Translator translator;

    @Inject
    KeywordAssistedSearchBuilder(Translator translator) {
        this.translator = translator;
    }

    String createCompositeQuery(Map<FilePropertyKey, String> advancedSearch, SearchCategory category) {
        String keySeparator = this.getTranslatedKeySeprator();
        StringBuilder sb = new StringBuilder();
        for (FilePropertyKey key : advancedSearch.keySet()) {
            String value = advancedSearch.get((Object)key);
            if (value == null || value.trim().length() <= 0) continue;
            sb.append(this.translator.translate(FilePropertyKeyUtils.getUntraslatedDisplayName(key, category)).toLowerCase());
            sb.append(keySeparator);
            sb.append(value);
            sb.append(' ');
        }
        int len = sb.length();
        if (len > 0) {
            sb.deleteCharAt(len - 1);
        }
        return sb.toString();
    }

    String getTranslatedKeySeprator() {
        return this.translator.translateWithComment("content separator ie. \"name:limewire\"", UNTRANSLATED_SEPARATOR);
    }

    public SearchInfo createAdvancedSearch(Map<FilePropertyKey, String> advancedSearch, SearchCategory searchCategory) {
        return DefaultSearchInfo.createAdvancedSearch(this.createCompositeQuery(advancedSearch, searchCategory), advancedSearch, searchCategory);
    }

    public SearchInfo attemptToCreateAdvancedSearch(String query, SearchCategory searchCategory) {
        if (searchCategory == SearchCategory.ALL || searchCategory == SearchCategory.OTHER) {
            return null;
        }
        String translatedKeySeparator = this.getTranslatedKeySeprator();
        String untranslatedKeySeparator = UNTRANSLATED_SEPARATOR;
        if (query.indexOf(translatedKeySeparator) > 0 || query.indexOf(untranslatedKeySeparator) > 0) {
            String lowerCaseUntranslatedQuery = this.translator.toLowerCaseEnglish(query);
            String lowerCaseTranslatedQuery = this.translator.toLowerCaseCurrentLocale(query);
            HashMap<FilePropertyKey, String> map = new HashMap<FilePropertyKey, String>();
            SortedList<KeyPacket> foundKeys = new SortedList<KeyPacket>();
            for (FilePropertyKey candidateKey : FilePropertyKey.values()) {
                String untranslatedKeyName = FilePropertyKeyUtils.getUntraslatedDisplayName(candidateKey, searchCategory);
                KeyPacket keyPacket = KeywordAssistedSearchBuilder.attemptToFindKey(candidateKey, this.translator.toLowerCaseEnglish(untranslatedKeyName), untranslatedKeySeparator, lowerCaseUntranslatedQuery);
                if (keyPacket != null) {
                    foundKeys.add(keyPacket);
                    continue;
                }
                if (this.translator.isCurrentLanguageEnglish() || (keyPacket = KeywordAssistedSearchBuilder.attemptToFindKey(candidateKey, this.translator.toLowerCaseCurrentLocale(this.translator.translate(untranslatedKeyName)), translatedKeySeparator, lowerCaseTranslatedQuery)) == null) continue;
                foundKeys.add(keyPacket);
            }
            if (foundKeys.size() == 0) {
                return null;
            }
            if (query.substring(0, ((KeyPacket)foundKeys.get(0)).getStartIndex()).trim().length() > 0) {
                return null;
            }
            for (int i = 0; i < foundKeys.size() - 1; ++i) {
                KeywordAssistedSearchBuilder.attemptToParseValue(query, map, (KeyPacket)foundKeys.get(i), ((KeyPacket)foundKeys.get(i + 1)).startIndex);
            }
            KeyPacket currentPacket = (KeyPacket)foundKeys.get(foundKeys.size() - 1);
            if (currentPacket.getEndIndex() != query.length()) {
                KeywordAssistedSearchBuilder.attemptToParseValue(query, map, currentPacket, query.length());
            } else {
                if (foundKeys.size() < 2) {
                    return null;
                }
                KeyPacket secondLastPacket = (KeyPacket)foundKeys.get(foundKeys.size() - 2);
                map.remove(secondLastPacket);
                KeywordAssistedSearchBuilder.attemptToParseValue(query, map, secondLastPacket, query.length());
            }
            if (map.size() == 0) {
                return null;
            }
            return this.createAdvancedSearch(map, searchCategory);
        }
        return null;
    }

    private static void attemptToParseValue(String query, Map<FilePropertyKey, String> map, KeyPacket currentPacket, int nextIndex) {
        String value = query.substring(currentPacket.getEndIndex(), nextIndex).trim();
        if (value.length() > 0) {
            map.put(currentPacket.getAssociatedKey(), value);
        }
    }

    private static KeyPacket attemptToFindKey(FilePropertyKey key, String lowerCaseKeyText, String keySeparator, String lowerCaseQuery) {
        return KeywordAssistedSearchBuilder.attemptToFindKey(key, lowerCaseKeyText, keySeparator, lowerCaseQuery, 0);
    }

    private static KeyPacket attemptToFindKey(FilePropertyKey key, String lowerCaseKeyText, String keySeparator, String lowerCaseQuery, int startSearchFrom) {
        int startIndex = lowerCaseQuery.indexOf(lowerCaseKeyText + keySeparator, startSearchFrom);
        if (startIndex > -1) {
            if (startIndex > 0 && lowerCaseQuery.substring(startIndex - 1, startIndex).trim().length() > 0) {
                return KeywordAssistedSearchBuilder.attemptToFindKey(key, lowerCaseKeyText, keySeparator, lowerCaseQuery, startIndex + lowerCaseKeyText.length());
            }
            return new KeyPacket(key, startIndex, startIndex + lowerCaseKeyText.length() + keySeparator.length());
        }
        return null;
    }

    public CategoryOverride parseCategoryOverride(String query) {
        String translatedKeySeparator = this.getTranslatedKeySeprator();
        String untranslatedKeySeparator = UNTRANSLATED_SEPARATOR;
        boolean firstSeparatorIsUntranslated = true;
        int firstSeparatorPosition = query.indexOf(untranslatedKeySeparator);
        if (firstSeparatorPosition < 0) {
            firstSeparatorPosition = query.indexOf(translatedKeySeparator);
            firstSeparatorIsUntranslated = false;
        }
        SearchCategory querySelectedSearchCategory = null;
        if (firstSeparatorPosition > 0 && (querySelectedSearchCategory = this.attemptToParseSearchCategory(query.substring(0, firstSeparatorPosition).trim(), firstSeparatorIsUntranslated)) == null && !this.translator.isCurrentLanguageEnglish() && translatedKeySeparator == untranslatedKeySeparator) {
            querySelectedSearchCategory = this.attemptToParseSearchCategory(query.substring(0, firstSeparatorPosition).trim(), !firstSeparatorIsUntranslated);
        }
        if (querySelectedSearchCategory == null) {
            return null;
        }
        return new CategoryOverride(querySelectedSearchCategory, query.substring(firstSeparatorPosition + 1));
    }

    private SearchCategory attemptToParseSearchCategory(String firstTerm, boolean firstSeparatorIsUntranslated) {
        if (firstSeparatorIsUntranslated) {
            String candidateTerm = this.translator.toLowerCaseEnglish(firstTerm);
            for (SearchCategory category : SearchCategory.values()) {
                if (!this.translator.toLowerCaseEnglish(SearchCategoryUtils.getUntranslatedName(category)).equals(candidateTerm)) continue;
                return category;
            }
        } else {
            String candidateTerm = this.translator.toLowerCaseCurrentLocale(firstTerm);
            for (SearchCategory category : SearchCategory.values()) {
                if (!this.translator.toLowerCaseCurrentLocale(this.translator.translate(SearchCategoryUtils.getUntranslatedName(category))).equals(candidateTerm)) continue;
                return category;
            }
        }
        return null;
    }

    private static class KeyPacket
    implements Comparable<KeyPacket> {
        private final FilePropertyKey associatedKey;
        private final int startIndex;
        private final int endIndex;

        public KeyPacket(FilePropertyKey associatedKey, int startIndex, int endIndex) {
            this.associatedKey = associatedKey;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }

        public FilePropertyKey getAssociatedKey() {
            return this.associatedKey;
        }

        public int getStartIndex() {
            return this.startIndex;
        }

        public int getEndIndex() {
            return this.endIndex;
        }

        @Override
        public int compareTo(KeyPacket o) {
            if (this.startIndex > o.startIndex) {
                return 1;
            }
            if (this.startIndex < o.startIndex) {
                return -1;
            }
            return 0;
        }
    }

    public static class CategoryOverride {
        private final SearchCategory category;
        private final String cutQuery;

        public CategoryOverride(SearchCategory category, String cutQuery) {
            this.category = category;
            this.cutQuery = cutQuery;
        }

        public SearchCategory getCategory() {
            return this.category;
        }

        public String getCutQuery() {
            return this.cutQuery;
        }
    }
}

