/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.search.resultpanel.list;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.limewire.core.api.FilePropertyKey;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.ui.swing.search.model.BasicDownloadState;
import org.limewire.ui.swing.search.model.VisualSearchResult;
import org.limewire.ui.swing.search.resultpanel.list.ListViewRowHeightRule;
import org.limewire.ui.swing.search.resultpanel.list.SearchHighlightUtil;

public class ListViewRowHeightRuleImpl
implements ListViewRowHeightRule {
    private static final Log LOG = LogFactory.getLog(ListViewRowHeightRuleImpl.class);
    private static final String OPEN_HTML = "<html>";
    private static final String CLOSE_HTML = "</html>";
    private static final String EMPTY_STRING = "";
    private final List<FilePropertyKey> audioKeyOrder;
    private final List<FilePropertyKey> videoKeyOrder;
    private final List<FilePropertyKey> documentKeyOrder;
    private final List<FilePropertyKey> programKeyOrder;
    private SearchHighlightUtil searchHighlightUtil;
    private String searchText;

    public ListViewRowHeightRuleImpl() {
        ArrayList<FilePropertyKey> keys = new ArrayList<FilePropertyKey>(Arrays.asList(FilePropertyKey.values()));
        Collections.sort(keys, new PropertyKeyComparator(FilePropertyKey.GENRE, FilePropertyKey.BITRATE, FilePropertyKey.TRACK_NUMBER));
        this.audioKeyOrder = new ArrayList<FilePropertyKey>(keys);
        Collections.sort(keys, new PropertyKeyComparator(FilePropertyKey.YEAR, FilePropertyKey.RATING, FilePropertyKey.DESCRIPTION, FilePropertyKey.HEIGHT, FilePropertyKey.WIDTH, FilePropertyKey.BITRATE));
        this.videoKeyOrder = new ArrayList<FilePropertyKey>(keys);
        Collections.sort(keys, new PropertyKeyComparator(FilePropertyKey.DATE_CREATED, FilePropertyKey.AUTHOR));
        this.documentKeyOrder = new ArrayList<FilePropertyKey>(keys);
        Collections.sort(keys, new PropertyKeyComparator(FilePropertyKey.PLATFORM, FilePropertyKey.COMPANY));
        this.programKeyOrder = new ArrayList<FilePropertyKey>(keys);
    }

    @Override
    public void initializeWithSearch(String search) {
        this.searchText = search;
        if (this.searchText != null) {
            this.searchHighlightUtil = new SearchHighlightUtil(search);
        }
    }

    @Override
    public ListViewRowHeightRule.RowDisplayResult getDisplayResult(VisualSearchResult vsr) {
        if (vsr.isSpam()) {
            return new RowDisplayResultImpl(ListViewRowHeightRule.RowDisplayConfig.HeadingOnly, vsr.getHeading(), null, null, vsr.isSpam(), vsr.getDownloadState());
        }
        switch (vsr.getDownloadState()) {
            case DOWNLOADING: 
            case DOWNLOADED: 
            case LIBRARY: 
            case REMOVED: {
                return new RowDisplayResultImpl(ListViewRowHeightRule.RowDisplayConfig.HeadingOnly, vsr.getHeading(), null, null, vsr.isSpam(), vsr.getDownloadState());
            }
            case NOT_STARTED: {
                ListViewRowHeightRule.PropertyMatch propertyMatch;
                String heading = vsr.getHeading();
                String highlightedHeading = this.highlightMatches(heading);
                LOG.debugf("Heading: {0} highlightedMatches: {1}", (Object)heading, (Object)highlightedHeading);
                String subheading = vsr.getSubHeading();
                String highlightedSubheading = this.highlightMatches(subheading);
                LOG.debugf("Subheading: {0} highlightedMatches: {1}", (Object)subheading, (Object)highlightedSubheading);
                if (!this.isDifferentLength(heading, highlightedHeading) && !this.isDifferentLength(subheading, highlightedSubheading) && (propertyMatch = this.getPropertyMatch(vsr)) != null) {
                    return this.newResult(ListViewRowHeightRule.RowDisplayConfig.HeadingSubHeadingAndMetadata, vsr, highlightedHeading, highlightedSubheading, propertyMatch);
                }
                return this.newResult(ListViewRowHeightRule.RowDisplayConfig.HeadingAndSubheading, vsr, highlightedHeading, highlightedSubheading, null);
            }
        }
        throw new UnsupportedOperationException("Unhandled download state: " + (Object)((Object)vsr.getDownloadState()));
    }

    private RowDisplayResultImpl newResult(ListViewRowHeightRule.RowDisplayConfig config, VisualSearchResult vsr, String heading, String subheading, ListViewRowHeightRule.PropertyMatch propertyMatch) {
        if (this.emptyOrNull(subheading)) {
            config = propertyMatch == null || propertyMatch.getKey() == null || EMPTY_STRING.equals(propertyMatch.getKey()) ? ListViewRowHeightRule.RowDisplayConfig.HeadingOnly : ListViewRowHeightRule.RowDisplayConfig.HeadingAndMetadata;
        }
        if (subheading.length() > 0) {
            subheading = OPEN_HTML + subheading + CLOSE_HTML;
        }
        return new RowDisplayResultImpl(config, heading, propertyMatch, subheading, vsr.isSpam(), vsr.getDownloadState());
    }

    private boolean emptyOrNull(String val) {
        return val == null || EMPTY_STRING.equals(val.trim());
    }

    private ListViewRowHeightRule.PropertyMatch getPropertyMatch(VisualSearchResult vsr) {
        if (this.searchText == null) {
            return null;
        }
        List<FilePropertyKey> keys = null;
        switch (vsr.getCategory()) {
            case AUDIO: {
                keys = this.audioKeyOrder;
                break;
            }
            case DOCUMENT: {
                keys = this.documentKeyOrder;
                break;
            }
            case PROGRAM: {
                keys = this.programKeyOrder;
                break;
            }
            case VIDEO: {
                keys = this.videoKeyOrder;
            }
        }
        if (keys == null) {
            return null;
        }
        for (FilePropertyKey key : keys) {
            String propertyMatch;
            String value = vsr.getPropertyString(key);
            if (value == null || !this.isDifferentLength(value, propertyMatch = this.highlightMatches(value))) continue;
            String betterKey = key.toString().toLowerCase();
            betterKey = betterKey.replace('_', ' ');
            return new PropertyMatchImpl(betterKey, propertyMatch);
        }
        return null;
    }

    private boolean isDifferentLength(String str1, String str2) {
        return str1 != null && str2 != null && str1.length() != str2.length();
    }

    private String highlightMatches(String sourceText) {
        boolean haveSearchText;
        boolean bl = haveSearchText = this.searchText != null && this.searchText.length() > 0;
        if (!haveSearchText) {
            return sourceText;
        }
        return this.searchHighlightUtil.highlight(sourceText);
    }

    private static class PropertyKeyComparator
    implements Comparator<FilePropertyKey> {
        private final FilePropertyKey[] keyOrder;

        public PropertyKeyComparator(FilePropertyKey ... keys) {
            this.keyOrder = keys;
        }

        @Override
        public int compare(FilePropertyKey o1, FilePropertyKey o2) {
            if (o1 == o2) {
                return 0;
            }
            for (FilePropertyKey key : this.keyOrder) {
                if (o1 == key) {
                    return -1;
                }
                if (o2 != key) continue;
                return 1;
            }
            return 0;
        }
    }

    private static class PropertyMatchImpl
    implements ListViewRowHeightRule.PropertyMatch {
        private final String highlightedVal;
        private final String key;

        public PropertyMatchImpl(String key, String highlightedVal) {
            this.key = key;
            this.highlightedVal = highlightedVal;
        }

        @Override
        public String getHighlightedValue() {
            return this.highlightedVal;
        }

        @Override
        public String getKey() {
            return this.key;
        }
    }

    private static class RowDisplayResultImpl
    implements ListViewRowHeightRule.RowDisplayResult {
        private final ListViewRowHeightRule.RowDisplayConfig config;
        private final String heading;
        private final String subheading;
        private final ListViewRowHeightRule.PropertyMatch metadata;
        private final boolean spam;
        private final BasicDownloadState initialDownloadState;

        public RowDisplayResultImpl(ListViewRowHeightRule.RowDisplayConfig config, String heading, ListViewRowHeightRule.PropertyMatch metadata, String subheading, boolean spam, BasicDownloadState downloadState) {
            this.config = config;
            this.heading = heading;
            this.metadata = metadata;
            this.subheading = subheading;
            this.spam = spam;
            this.initialDownloadState = downloadState;
        }

        @Override
        public ListViewRowHeightRule.RowDisplayConfig getConfig() {
            return this.config;
        }

        @Override
        public String getHeading() {
            return this.heading;
        }

        @Override
        public ListViewRowHeightRule.PropertyMatch getMetadata() {
            return this.metadata;
        }

        @Override
        public String getSubheading() {
            return this.subheading;
        }

        @Override
        public boolean isSpam() {
            return this.spam;
        }

        @Override
        public boolean isStale(VisualSearchResult vsr) {
            return vsr.getDownloadState() != this.initialDownloadState || vsr.isSpam() != this.spam;
        }
    }
}

