/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.tray;

import javax.swing.Action;
import javax.swing.Icon;
import org.limewire.ui.swing.util.I18n;

public class Notification {
    private String title;
    private String message;
    private Action[] actions;
    private Icon icon;

    public Notification(String title, String message, Icon icon, Action ... actions) {
        this.title = title;
        this.message = message;
        this.icon = icon;
        this.actions = actions;
    }

    public Notification(String message, Icon icon, Action ... actions) {
        this(null, message, icon, actions);
    }

    public Notification(String title, String message, Action ... actions) {
        this(title, message, (Icon)null, actions);
    }

    public Notification(String message, Action ... actions) {
        this((String)null, message, (Icon)null, actions);
    }

    public String getMessage() {
        return this.message;
    }

    public Action[] getActions() {
        return this.actions;
    }

    public String getActionName() {
        String actionName = this.actions.length > 0 && this.actions[0].getValue("Name") != null ? this.actions[0].getValue("Name").toString() : I18n.trc("Launch Action Text (Notification)", "Launch");
        return actionName;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String getTitle() {
        return this.title;
    }
}

