/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.util;

import com.google.inject.Inject;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import net.miginfocom.swing.MigLayout;
import org.limewire.core.api.Application;
import org.limewire.core.api.download.DownloadAction;
import org.limewire.core.api.download.DownloadException;
import org.limewire.core.api.download.SaveLocationManager;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.ui.swing.action.UrlAction;
import org.limewire.ui.swing.components.FocusJOptionPane;
import org.limewire.ui.swing.components.HyperlinkButton;
import org.limewire.ui.swing.components.LimeJDialog;
import org.limewire.ui.swing.components.MultiLineLabel;
import org.limewire.ui.swing.settings.SwingUiSettings;
import org.limewire.ui.swing.transfer.TransferTrayNavigator;
import org.limewire.ui.swing.util.DownloadExceptionHandler;
import org.limewire.ui.swing.util.FileChooser;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.SwingUtils;
import org.limewire.util.FileUtils;

public class DownloadExceptionHandlerImpl
implements DownloadExceptionHandler {
    private static final Log LOG = LogFactory.getLog(DownloadExceptionHandlerImpl.class);
    private final SaveLocationManager saveLocationManager;
    private final Application application;
    private final TransferTrayNavigator transferTrayNavigator;

    @Inject
    public DownloadExceptionHandlerImpl(SaveLocationManager saveLocationManager, Application application, TransferTrayNavigator transferTrayNavigator) {
        this.saveLocationManager = saveLocationManager;
        this.application = application;
        this.transferTrayNavigator = transferTrayNavigator;
    }

    @Override
    public void handleDownloadException(final DownloadAction downLoadAction, final DownloadException e, final boolean supportNewSaveFileName) {
        SwingUtils.invokeNowOrLater(new Runnable(){

            @Override
            public void run() {
                DownloadExceptionHandlerImpl.this.handleException(downLoadAction, e, supportNewSaveFileName);
            }
        });
    }

    private void handleException(DownloadAction downLoadAction, DownloadException e, boolean supportNewSaveFileName) {
        if (e.getErrorCode() == DownloadException.ErrorCode.DOWNLOAD_CANCELLED) {
            downLoadAction.downloadCanceled(e);
            return;
        }
        if (e.getErrorCode() == DownloadException.ErrorCode.FILE_ALREADY_DOWNLOADING) {
            downLoadAction.downloadCanceled(e);
            this.showErrorMessage(e);
            return;
        }
        if (e.getErrorCode() != DownloadException.ErrorCode.FILE_ALREADY_EXISTS && e.getErrorCode() != DownloadException.ErrorCode.FILE_IS_ALREADY_DOWNLOADED_TO) {
            downLoadAction.downloadCanceled(e);
            this.showErrorMessage(e);
            return;
        }
        if (e.getErrorCode() == DownloadException.ErrorCode.FILE_IS_ALREADY_DOWNLOADED_TO && !supportNewSaveFileName) {
            downLoadAction.downloadCanceled(e);
            this.showErrorMessage(e);
            return;
        }
        File saveFile = null;
        if (supportNewSaveFileName && SwingUiSettings.AUTO_RENAME_DUPLICATE_FILES.getValue()) {
            saveFile = this.getAutoSaveFile(e);
        } else {
            if (supportNewSaveFileName) {
                saveFile = FileChooser.getSaveAsFile(GuiUtils.getMainFrame(), I18n.tr("Save File As..."), e.getFile());
            } else {
                saveFile = e.getFile();
                if (saveFile != null && saveFile.exists()) {
                    this.createOverwriteDialogue(saveFile, downLoadAction, e, supportNewSaveFileName);
                    return;
                }
            }
            if (saveFile == null) {
                downLoadAction.downloadCanceled(e);
                return;
            }
        }
        this.download(downLoadAction, supportNewSaveFileName, saveFile, saveFile.exists());
    }

    private void showErrorMessage(DownloadException e) {
        Object message = null;
        switch (e.getErrorCode()) {
            case FILE_ALREADY_UPLOADING: {
                this.transferTrayNavigator.selectUploads();
                message = I18n.tr("Sorry, this file is already being uploaded.");
                break;
            }
            case FILE_ALREADY_DOWNLOADING: {
                this.transferTrayNavigator.selectDownloads();
                message = I18n.tr("Sorry, this file is already being downloaded.");
                break;
            }
            case DIRECTORY_NOT_WRITEABLE: 
            case DIRECTORY_DOES_NOT_EXIST: 
            case NOT_A_DIRECTORY: 
            case PATH_NAME_TOO_LONG: {
                message = I18n.tr("Sorry, you can't download files to this location.");
                break;
            }
            case NO_TORRENT_MANAGER: {
                MultiLineLabel label = new MultiLineLabel(I18n.tr("Sorry, there is a problem with torrents.\nPlease try reinstalling LimeWire to solve this problem."));
                HyperlinkButton help = new HyperlinkButton(I18n.tr("You can also ask for help on the forums."));
                help.addActionListener(new UrlAction("http://www.limewire.com/client_redirect/?page=bitTorrentBugs", this.application));
                JPanel panel = new JPanel();
                panel.setOpaque(false);
                panel.setLayout(new MigLayout("gapy 15"));
                panel.add((Component)label, "wrap");
                panel.add((Component)help, "wrap");
                panel.validate();
                message = panel;
                break;
            }
            case FILES_STILL_RESUMING: {
                message = I18n.tr("Sorry, we are still loading your old downloads.\nPlease wait to add a new download until we are done.");
                break;
            }
            default: {
                message = I18n.tr("Sorry, there was a problem downloading your file.");
            }
        }
        LOG.error(message, e);
        FocusJOptionPane.showMessageDialog(GuiUtils.getMainFrame(), message, I18n.tr("Download"), 1);
    }

    private File getAutoSaveFile(DownloadException e) {
        File saveFile = e.getFile();
        int index = 1;
        String fileName = FileUtils.getFilenameNoExtension(saveFile.getName());
        String extension = FileUtils.getFileExtension(saveFile);
        while (saveFile.exists() || this.saveLocationManager.isSaveLocationTaken(saveFile)) {
            String newFileName = fileName + "(" + index + ")";
            if (extension.length() > 0) {
                newFileName = newFileName + "." + extension;
            }
            saveFile = new File(saveFile.getParentFile(), newFileName);
            ++index;
        }
        return saveFile;
    }

    private void download(DownloadAction downLoadAction, boolean supportNewSaveFileName, File saveFile, boolean overwrite) {
        File newSaveFile = supportNewSaveFileName ? saveFile : saveFile.getParentFile();
        try {
            downLoadAction.download(newSaveFile, overwrite);
        }
        catch (DownloadException e1) {
            this.handleDownloadException(downLoadAction, e1, supportNewSaveFileName);
        }
    }

    private void createOverwriteDialogue(final File overwriteFile, final DownloadAction downLoadAction, final DownloadException ex, final boolean supportNewSaveFileName) {
        final LimeJDialog dialog = new LimeJDialog(GuiUtils.getMainFrame());
        dialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        MultiLineLabel message = new MultiLineLabel(I18n.tr("File already exists. What do you want to do?"), 400);
        JTextField filePathField = new JTextField(25);
        filePathField.setEnabled(false);
        filePathField.setText(overwriteFile.getAbsolutePath());
        JToggleButton overwriteButton = null;
        overwriteButton = new JToggleButton(I18n.tr("Overwrite"));
        overwriteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                dialog.dispose();
                DownloadExceptionHandlerImpl.this.download(downLoadAction, supportNewSaveFileName, overwriteFile, true);
            }
        });
        JButton cancelButton = new JButton(I18n.tr("Cancel"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
                File oldSaveFile = overwriteFile;
                File oldSaveFileParent = overwriteFile.getParentFile() != null ? overwriteFile.getParentFile() : overwriteFile;
                File newSaveParent = FileChooser.getInputDirectory(GuiUtils.getMainFrame(), I18n.tr("Choose a new folder to save download."), I18n.tr("Select"), oldSaveFileParent);
                if (newSaveParent != null && new File(newSaveParent, oldSaveFile.getName()).exists()) {
                    File saveFile = new File(newSaveParent, oldSaveFile.getName());
                    DownloadExceptionHandlerImpl.this.createOverwriteDialogue(saveFile, downLoadAction, ex, supportNewSaveFileName);
                    return;
                }
                if (newSaveParent != null) {
                    File saveFile = new File(newSaveParent, oldSaveFile.getName());
                    DownloadExceptionHandlerImpl.this.download(downLoadAction, supportNewSaveFileName, saveFile, false);
                }
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new MigLayout("hidemode 3, gapy 10", "", ""));
        panel.add((Component)message, "span 2, wrap");
        panel.add((Component)filePathField, "grow x, push, wrap");
        panel.add((Component)overwriteButton, "alignx right");
        panel.add(cancelButton);
        dialog.setContentPane(panel);
        dialog.pack();
        dialog.setLocationRelativeTo(GuiUtils.getMainFrame());
        dialog.setVisible(true);
    }
}

