/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.util;

import java.awt.Font;
import java.util.Locale;
import java.util.Map;
import javax.swing.UIManager;
import org.limewire.core.settings.ApplicationSettings;
import org.limewire.ui.swing.util.FontUtils;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.util.OSUtils;
import org.limewire.util.StringUtils;

public class LocaleUtils {
    private LocaleUtils() {
    }

    public static Locale getCurrentLocale() {
        return new Locale(ApplicationSettings.LANGUAGE.get(), ApplicationSettings.COUNTRY.get(), ApplicationSettings.LOCALE_VARIANT.get());
    }

    public static void setLocaleFromPreferences() {
        if (ApplicationSettings.LANGUAGE.get().equals("")) {
            ApplicationSettings.LANGUAGE.set("en");
        }
        Locale locale = new Locale(ApplicationSettings.LANGUAGE.get(), ApplicationSettings.COUNTRY.get(), ApplicationSettings.LOCALE_VARIANT.get());
        Locale.setDefault(locale);
        StringUtils.setLocale(locale);
        GuiUtils.setLocale(locale);
        I18n.setLocale(locale);
    }

    public static void validateLocaleAndFonts() {
        if (OSUtils.isMacOSX()) {
            return;
        }
        String s = LocaleUtils.getCurrentLocale().getDisplayName();
        if (!LocaleUtils.checkUIFonts("dialog", s)) {
            ApplicationSettings.LANGUAGE.set("en");
            ApplicationSettings.COUNTRY.set("");
            ApplicationSettings.LOCALE_VARIANT.set("");
            LocaleUtils.setLocaleFromPreferences();
        }
    }

    private static boolean checkUIFonts(String newFont, String testString) {
        String[] comps = new String[]{"TextField.font", "PasswordField.font", "TextArea.font", "TextPane.font", "EditorPane.font", "FormattedTextField.font", "Button.font", "CheckBox.font", "RadioButton.font", "ToggleButton.font", "ProgressBar.font", "ComboBox.font", "InternalFrame.titleFont", "DesktopIcon.font", "TitledBorder.font", "Label.font", "List.font", "TabbedPane.font", "Table.font", "TableHeader.font", "MenuBar.font", "Menu.font", "Menu.acceleratorFont", "MenuItem.font", "MenuItem.acceleratorFont", "PopupMenu.font", "CheckBoxMenuItem.font", "CheckBoxMenuItem.acceleratorFont", "RadioButtonMenuItem.font", "RadioButtonMenuItem.acceleratorFont", "Spinner.font", "Tree.font", "ToolBar.font", "OptionPane.messageFont", "OptionPane.buttonFont", "ToolTip.font"};
        boolean displayable = false;
        for (int i = 0; i < comps.length; ++i) {
            displayable |= LocaleUtils.checkFont(comps[i], newFont, testString, false);
        }
        for (Map.Entry entry : UIManager.getDefaults().entrySet()) {
            Font f;
            if (!(entry.getValue() instanceof Font) || (f = (Font)entry.getValue()) == null || newFont.equalsIgnoreCase(f.getName()) || FontUtils.canDisplay(f, testString) || !FontUtils.canDisplay(f = new Font(newFont, f.getStyle(), f.getSize()), testString)) continue;
            entry.setValue(f);
            displayable = true;
        }
        return displayable;
    }

    private static boolean checkFont(String fontName, String newName, String testString, boolean force) {
        boolean displayable = true;
        Font f = UIManager.getFont(fontName);
        if (f != null && !newName.equalsIgnoreCase(f.getName())) {
            if (!FontUtils.canDisplay(f, testString) || force) {
                if (FontUtils.canDisplay(f = new Font(newName, f.getStyle(), f.getSize()), testString)) {
                    UIManager.put(fontName, f);
                } else {
                    displayable = false;
                }
            }
        } else {
            displayable = f != null ? FontUtils.canDisplay(f, testString) : false;
        }
        return displayable;
    }
}

